﻿---
title: Quickstart: Send OTLP data to Elastic Serverless or Elastic Cloud Hosted
description: Learn how to use the Elastic Cloud Managed OTLP Endpoint to send logs, metrics, and traces to Elastic Serverless and Elastic Cloud Hosted.
url: https://www.elastic.co/docs/solutions/observability/get-started/quickstart-elastic-cloud-otel-endpoint
products:
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Preview
  - Self-managed Elastic deployments: Unavailable
---

# Quickstart: Send OTLP data to Elastic Serverless or Elastic Cloud Hosted
You can send OpenTelemetry data to Elastic Serverless and Elastic Cloud Hosted using the Elastic Cloud Managed OTLP Endpoint endpoint.
The Elastic Cloud Managed OTLP Endpoint provides an endpoint for OpenTelemetry SDKs and Collectors to send telemetry data, with Elastic handling scaling, data processing, and storage. Refer to [Elastic Cloud Managed OTLP Endpoint](https://www.elastic.co/docs/reference/opentelemetry/motlp) for more information.
The Elastic Cloud Managed OTLP Endpoint is designed for the following use cases:
- Logs & Infrastructure Monitoring: Logs forwarded in OTLP format and host and Kubernetes metrics in OTLP format.
- APM: Application telemetry in OTLP format.

Keep reading to learn how to use the Elastic Cloud Managed OTLP Endpoint to send logs, metrics, and traces to your Serverless project or Elastic Cloud Hosted cluster.
<note applies-to="Elastic Cloud Hosted: Preview">
  On Elastic Cloud Hosted, the Managed OTLP endpoint requires a deployment version 9.2 or later and might not be available in all Elastic Cloud Hosted regions during the Technical Preview.
</note>


## Send data to Elastic

Follow these steps to send data to Elastic using the Elastic Cloud Managed OTLP Endpoint.
<stepper>
  <step title="Retrieve your endpoint and API key">
    To retrieve your Elastic Cloud Managed OTLP Endpoint endpoint address and API key, follow these steps:
    <applies-switch>
      <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
        1. In Elastic Cloud, create an Observability project or open an existing one.
        2. Go to **Add data**, select **Applications** and then select **OpenTelemetry**.
        3. Copy the endpoint and authentication headers values.
        Alternatively, you can retrieve the endpoint from the **Manage project** page and create an API key manually from the **API keys** page.
      </applies-item>

      <applies-item title="ess: preview" applies-to="Elastic Cloud Hosted: Preview">
        You need an Elastic Cloud Hosted deployment version 9.2 or later.
        1. In Elastic Cloud, create an Elastic Cloud Hosted deployment or open an existing one.
        2. Go to **Add data**, select **Applications** and then select **OpenTelemetry**.
        3. Copy the endpoint and authentication headers values.
      </applies-item>
    </applies-switch>
  </step>

  <step title="Configure your OTLP shipper">
    The final step is to configure your Collector or SDK to use the Elastic Cloud Managed OTLP Endpoint endpoint and your Elastic API key to send data to Elastic Cloud.
    <tab-set>
      <tab-item title="OpenTelemetry Collector example">
        To send data to the Elastic Cloud Managed OTLP Endpoint from the Elastic Distribution of OpenTelemetry Collector or the contrib Collector, configure the `otlp` exporter:
        ```yaml
        exporters:
          otlp:
            endpoint: https://<motlp-endpoint>
            headers:
              Authorization: ApiKey <your-api-key>
        ```
        Set the API key as an environment variable or directly in the configuration as shown in the example.
      </tab-item>

      <tab-item title="OpenTelemetry SDK example">
        To send data to the Elastic Cloud Managed OTLP Endpoint from Elastic Distribution of OpenTelemetry SDKs or contrib SDKs, set the following variables in your application's environment:
        ```bash
        export OTEL_EXPORTER_OTLP_ENDPOINT="https://<motlp-endpoint>"
        export OTEL_EXPORTER_OTLP_HEADERS="Authorization=ApiKey <your-api-key>"
        ```
      </tab-item>

      <tab-item title="Kubernetes example">
        You can store your API key in a Kubernetes secret and reference it in your OTLP exporter configuration. This is more secure than hardcoding credentials.The API key from Kibana does not include the `ApiKey` scheme. You must prepend `ApiKey ` before storing it.For example, if your API key from Kibana is `abc123`, run:
        ```bash
        kubectl create secret generic otlp-api-key \
          --namespace=default \
          --from-literal=api-key="ApiKey abc123"
        ```
        Mount the secret as an environment variable or file, then reference it in your OTLP exporter configuration:
        ```yaml
        exporters:
          otlp:
            endpoint: https://<motlp-endpoint>
            headers:
              Authorization: ${API_KEY}
        ```
        And in your deployment spec:
        ```yaml
        env:
          - name: API_KEY
            valueFrom:
              secretKeyRef:
                name: otlp-api-key
                key: api-key
        ```

        <important>
          When creating a Kubernetes secret, always encode the full string in Base64, including the scheme (for example, `ApiKey abc123`).
        </important>
      </tab-item>
    </tab-set>
  </step>
</stepper>


## Differences from the Elastic APM Endpoint

The Elastic Cloud Managed OTLP Endpoint ensures that OpenTelemetry data is stored without any schema translation, preserving both OpenTelemetry semantic conventions and resource attributes. It supports ingesting OTLP logs, metrics, and traces in a unified manner, ensuring consistent treatment across all telemetry data.

## Troubleshooting

The following sections provide troubleshooting information for the Elastic Cloud Managed OTLP Endpoint.

### You don't have a Collector or SDK running

Don't have a collector or SDK running? Spin up an EDOT collector in few steps:
- [Kubernetes Quickstart](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/serverless/k8s)
- [Hosts & VMs Quickstart](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/serverless/hosts_vms)
- [Docker Quickstart](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/serverless/docker)


### Api Key prefix not found

The following error is due to an improperly formatted API key:
```txt
Exporting failed. Dropping data.
{"kind": "exporter", "data_type": }
"Unauthenticated desc = ApiKey prefix not found"
```

You must format your API key as `"Authorization": "ApiKey <api-key-value-here>"` or `"Authorization=ApiKey <api-key>"` depending on whether you're using a collector or SDK.

### Error: too many requests

If you see HTTP `429 Too Many Requests` errors when sending data through the Elastic Cloud Managed OTLP Endpoint (mOTLP) endpoint, your project might be hitting ingest rate limits.
Refer to the dedicated [429 errors when using the Elastic Cloud Managed OTLP Endpoint](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/429-errors-motlp) troubleshooting guide for details on causes, rate limits, and solutions.

## Provide feedback

Help improve the Elastic Cloud Managed OTLP Endpoint by sending us feedback in our [discussion forum](https://discuss.elastic.co/c/apm) or [community Slack](https://elasticstack.slack.com/signup#/domain-signup).
For EDOT collector feedback, open an issue in the [elastic-agent repository](https://github.com/elastic/elastic-agent/issues).

## What's next

Visualize your OpenTelemetry data. Learn more in [Visualize OpenTelemetry data](https://www.elastic.co/docs/solutions/observability/otlp-visualize).