﻿---
title: Upgrade
description: Instructions for upgrading the EDOT Helm chart release for Kubernetes monitoring.
url: https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/use-cases/kubernetes/upgrade
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Collector: Generally available
---

# Upgrade
<note>
  Before upgrading or updating the release configuration, refer to the [compatibility matrix](/docs/solutions/observability/get-started/opentelemetry/use-cases/kubernetes/prerequisites-compatibility#compatibility-matrix) for a list of supported versions and [customizing configuration](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/use-cases/kubernetes/customization) for a list of supported configurable parameters.
</note>

To upgrade an installed release, run a `helm upgrade` command providing the desired chart version and using the correct `values.yaml` for your environment. For example:
```bash
helm repo update open-telemetry
helm search repo open-telemetry/opentelemetry-kube-stack --versions

helm upgrade --namespace opentelemetry-operator-system opentelemetry-kube-stack open-telemetry/opentelemetry-kube-stack \
--values 'https://raw.githubusercontent.com/elastic/elastic-agent/refs/tags/v9.3.0/deploy/helm/edot-collector/kube-stack/values.yaml' \
--version 0.12.4
```

If [cert-manager integration](/docs/solutions/observability/get-started/opentelemetry/use-cases/kubernetes/customization#cert-manager-integrated-installation) is disabled, Helm generates a new self-signed TLS certificate with every update, even if there are no actual changes to apply.