﻿---
title: Kubernetes observability with EDOT
description: Detailed description of the Kubernetes setup for EDOT, including components and customization guidance.
url: https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/use-cases/kubernetes
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Collector: Generally available
---

# Kubernetes observability with EDOT
The [quickstart guides](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart) for Kubernetes install a set of different EDOT Collectors and EDOT SDKs to cover collection of OpenTelemetry data for infrastructure monitoring, logs collection and application monitoring.
The Kubernetes setup relies on the OpenTelemetry Operator, configured to automate orchestration of EDOT as follows:
- EDOT Collector Cluster: Collection of cluster metrics.
- EDOT Collector Daemon: Collection of node metrics, logs, and application telemetry.
- EDOT Collector Gateway: Preprocessing, aggregation, and ingestion of data into Elastic.
- EDOT SDKs: Annotated applications are auto-instrumented with [EDOT SDKs](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks).

The following diagram summarizes the previous components and how they interact with Elastic:
![K8s-architecture](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/images/EDOT-K8s-architecture.png)
Read on to learn how to:
- Install the [OpenTelemetry Operator](https://github.com/open-telemetry/opentelemetry-operator/) using the [kube-stack Helm chart](https://github.com/open-telemetry/opentelemetry-helm-charts/tree/main/charts/opentelemetry-kube-stack).
- Use the EDOT Collectors to send Kubernetes logs, metrics, and application traces to an Elasticsearch cluster.
- Use the operator for applications [auto-instrumentation](https://opentelemetry.io/docs/kubernetes/operator/automatic/) in all supported languages.