﻿---
title: Quickstart for hosts / VMs on Elastic Cloud Serverless
description: Learn how to set up the EDOT Collector and EDOT SDKs in a Docker environment with {{serverless-full}} to collect host metrics, logs, and application traces. Send the data through OTLP to your Elastic Serverless Project.
url: https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/serverless/hosts_vms
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Collector: Generally available
---

# Quickstart for hosts / VMs on Elastic Cloud Serverless
Learn how to set up the EDOT Collector and EDOT SDKs in a Docker environment with Elastic Cloud Serverless to collect host metrics, logs, and application traces. Send the data through OTLP to your Elastic Serverless Project.

## Guided setup

Use the **Add data** screen in Elastic Observability to generate install commands that are already configured with the values you need.
1. Open Elastic Observability.
2. Go to **Add data**.
3. Select what you want to monitor.
4. Follow the instructions.


## Manual installation

Follow these steps to deploy the EDOT Collector and EDOT OTel SDKs with Elastic Cloud Serverless.
<stepper>
  <step title="Download the EDOT Collector">
    [Download the EDOT Collector](https://www.elastic.co/docs/reference/edot-collector/download) for your operating system.
  </step>

  <step title="Configure the EDOT Collector">
    Follow these steps to retrieve the managed OTLP endpoint URL for your Serverless project:
    1. In Elastic Cloud Serverless, open your Observability project.
    2. Go to **Add data** → **Application** → **OpenTelemetry**.
    3. Select **Managed OTLP Endpoint** in the second step.
    4. Copy the OTLP endpoint configuration value.
    5. Select **Create API Key** to generate an API key.
    Replace `<ELASTIC_OTLP_ENDPOINT>` and `<ELASTIC_API_KEY>` before applying the following command.
    <tab-set>
      <tab-item title="Linux">
        ```bash
        ELASTIC_OTLP_ENDPOINT=<ELASTIC_OTLP_ENDPOINT> && \
        ELASTIC_API_KEY=<ELASTIC_API_KEY> && \
        cp ./otel_samples/managed_otlp/logs_metrics_traces.yml ./otel.yml && \
        mkdir -p ./data/otelcol && \
        sed -i "s#\${env:STORAGE_DIR}#${PWD}/data/otelcol#g" ./otel.yml && \
        sed -i "s#\${env:ELASTIC_OTLP_ENDPOINT}#${ELASTIC_OTLP_ENDPOINT}#g" ./otel.yml && \
        sed -i "s#\${env:ELASTIC_API_KEY}#${ELASTIC_API_KEY}#g" ./otel.yml
        ```
      </tab-item>

      <tab-item title="macOS">
        ```bash
        ELASTIC_OTLP_ENDPOINT=<ELASTIC_OTLP_ENDPOINT> && \
        ELASTIC_API_KEY=<ELASTIC_API_KEY> && \
        cp ./otel_samples/managed_otlp/logs_metrics_traces.yml ./otel.yml && \
        mkdir -p ./data/otelcol && \
        sed -i '' "s#\${env:STORAGE_DIR}#${PWD}/data/otelcol#g" ./otel.yml && \
        sed -i '' "s#\${env:ELASTIC_OTLP_ENDPOINT}#${ELASTIC_OTLP_ENDPOINT}#g" ./otel.yml && \
        sed -i '' "s#\${env:ELASTIC_API_KEY}#${ELASTIC_API_KEY}#g" ./otel.yml
        ```
      </tab-item>

      <tab-item title="Windows">
        ```powershell
        Remove-Item -Path .\otel.yml -ErrorAction SilentlyContinue
        Copy-Item .\otel_samples\managed_otlp\logs_metrics_traces.yml .\otel.yml
        New-Item -ItemType Directory -Force -Path .\data\otelcol | Out-Null

        $content = Get-Content .\otel.yml
        $content = $content -replace '\${env:STORAGE_DIR}', "$PWD\data\otelcol"
        $content = $content -replace '\${env:ELASTIC_OTLP_ENDPOINT}', "<ELASTIC_OTLP_ENDPOINT>"
        $content = $content -replace '\${env:ELASTIC_API_KEY}', "<ELASTIC_API_KEY>"
        $content | Set-Content .\otel.yml
        ```
      </tab-item>
    </tab-set>
  </step>

  <step title="Run the EDOT Collector">
    Run the following command to run the EDOT Collector.
    <tab-set>
      <tab-item title="Linux and macOS">
        ```bash
        sudo ./otelcol --config otel.yml
        ```
      </tab-item>

      <tab-item title="Windows">
        ```powershell
        .\elastic-agent.exe otel --config otel.yml
        ```
      </tab-item>
    </tab-set>

    <note>
      The Collector opens ports `4317` and `4318` to receive application data from locally running OTel SDKs without authentication. This allows the SDKs to send data without any further configuration needed as they use this endpoint by default.
    </note>
  </step>

  <step title="(Optional) Instrument your applications">
    To collect telemetry from applications and use the EDOT Collector as a gateway,
    instrument your target applications following the setup instructions:
    - [Android](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android)
    - [.NET](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/dotnet/setup)
    - [iOS](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios)
    - [Java](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java/setup)
    - [Node.js](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node/setup)
    - [PHP](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/php/setup)
    - [Python](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/setup)
    Configure your SDKs to send the data to the local EDOT Collector using OTLP/gRPC (`http://localhost:4317`) or OTLP/HTTP (`http://localhost:4318`).
  </step>

  <step title="Explore your data">
    Go to Kibana and select **Dashboards** to explore your newly collected data.
  </step>
</stepper>


## Troubleshooting

The following issues might occur.

### API Key prefix not found

The following error is due to an improperly formatted API key:
```txt
Exporting failed. Dropping data.
{"kind": "exporter", "data_type": }
"Unauthenticated desc = ApiKey prefix not found"
```

Format your API key as `"Authorization": "ApiKey <api-key-value-here>"` or `"Authorization=ApiKey <api-key>"` depending on whether you're using a Collector or SDK.

### Error: too many requests

The managed endpoint has per-project rate limits in place. If you reach this limit, contact our [support team](https://support.elastic.co).