﻿---
title: Quickstart for Docker on Elastic Cloud Serverless
description: Learn how to set up the EDOT Collector and EDOT SDKs in a Docker environment with {{serverless-full}} to collect host metrics, logs, and application traces.
url: https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/serverless/docker
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Collector: Generally available
---

# Quickstart for Docker on Elastic Cloud Serverless
Learn how to set up the EDOT Collector and EDOT SDKs in a Docker environment with Elastic Cloud Serverless to collect host metrics, logs, and application traces.

## Guided setup

Use the **Add data** screen in Elastic Observability to generate install commands that are already configured with the values you need.
1. Open Elastic Observability.
2. Go to **Add data**.
3. Select what you want to monitor.
4. Follow the instructions.


## Manual installation

Follow these steps to deploy the EDOT Collector and EDOT OTel SDKs in Docker with Elastic Cloud Serverless.
<stepper>
  <step title="Create the config file">
    Create a `otel-collector-config.yml` file with your EDOT collector configuration. For more details, refer to the [configuration reference](https://www.elastic.co/docs/reference/edot-collector/config/default-config-standalone) for Elastic Cloud Managed OTLP Endpoint.
  </step>

  <step title="Retrieve your settings">
    Follow these steps to retrieve the managed OTLP endpoint URL for your Serverless project:
    1. In Elastic Cloud Serverless, open your Observability project.
    2. Go to **Add data** → **Application** → **OpenTelemetry**.
    3. Select **Managed OTLP Endpoint** in the second step.
    4. Copy the OTLP endpoint configuration value.
    5. Select **Create API Key** to generate an API key.
  </step>

  <step title="Create the .env file">
    Create a `.env` file with the following content, replacing the placeholder values with your actual Elastic Cloud credentials:
    ```bash
    HOST_FILESYSTEM=/
    DOCKER_SOCK=/var/run/docker.sock
    ELASTIC_AGENT_OTEL=true
    COLLECTOR_CONTRIB_IMAGE=elastic/elastic-agent:9.3.0
    ELASTIC_API_KEY=<your_api_key_here>
    ELASTIC_OTLP_ENDPOINT=<your_endpoint_here>
    OTEL_COLLECTOR_CONFIG=/path/to/otel-collector-config.yml
    ```
  </step>

  <step title="Create the compose file">
    Create a `compose.yml` file with the following content:
    ```yaml
    services:
       otel-collector:
       image: ${COLLECTOR_CONTRIB_IMAGE}
       container_name: otel-collector
       deploy:
          resources:
             limits:
             memory: 1.5G
       restart: unless-stopped
       command: ["--config", "/etc/otelcol-config.yml" ]
       network_mode: host
       user: 0:0
       volumes:
          - ${HOST_FILESYSTEM}:/hostfs:ro
          - ${DOCKER_SOCK}:/var/run/docker.sock:ro
          - ${OTEL_COLLECTOR_CONFIG}:/etc/otelcol-config.yml
       environment:
          - HOST_FILESYSTEM
          - ELASTIC_AGENT_OTEL
          - ELASTIC_API_KEY
          - ELASTIC_OTLP_ENDPOINT
          - STORAGE_DIR=/usr/share/elastic-agent
    ```
  </step>

  <step title="Start the Collector">
    Start the collector by running:
    ```bash
    docker compose up -d
    ```
  </step>

  <step title="(Optional) Instrument your applications">
    To collect telemetry from applications and use the EDOT Collector as a gateway,
    instrument your target applications following the setup instructions:
    - [Android](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android)
    - [.NET](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/dotnet/setup)
    - [iOS](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios)
    - [Java](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java/setup)
    - [Node.js](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node/setup)
    - [PHP](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/php/setup)
    - [Python](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/setup)
    Configure your SDKs to send the data to the local EDOT Collector using OTLP/gRPC (`http://localhost:4317`) or OTLP/HTTP (`http://localhost:4318`).
  </step>

  <step title="Install the content pack">
    Install the **[Docker OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/docker_otel)** integration in Kibana.
  </step>

  <step title="Explore your data">
    Go to Kibana and select **Dashboards** to explore your newly collected data.
  </step>
</stepper>


## Troubleshooting

The following issues might occur.

### API Key prefix not found

The following error is due to an improperly formatted API key:
```txt
Exporting failed. Dropping data.
{"kind": "exporter", "data_type": }
"Unauthenticated desc = ApiKey prefix not found"
```

Format your API key as `"Authorization": "ApiKey <api-key-value-here>"` or `"Authorization=ApiKey <api-key>"` depending on whether you're using a Collector or SDK.

### Error: too many requests

The managed endpoint has per-project rate limits in place. If you reach this limit, contact our [support team](https://support.elastic.co).