﻿---
title: Quickstart for Kubernetes on Elastic Cloud Hosted
description: Learn how to set up the EDOT Collector and EDOT SDKs in a Kubernetes environment with {{ech}} to collect host metrics, logs and application traces.
url: https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/ech/k8s
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Collector: Generally available
---

# Quickstart for Kubernetes on Elastic Cloud Hosted
Learn how to set up the EDOT Collector and EDOT SDKs in a Kubernetes environment with Elastic Cloud Hosted (ECH) to collect host metrics, logs and application traces.

## Guided setup

Use the **Add data** screen in Elastic Observability to generate install commands that are already configured with the values you need.
1. Open Elastic Observability.
2. Go to **Add data**.
3. Select what you want to monitor.
4. Follow the instructions.


## Prerequisites

To use the OpenTelemetry Kube Stack Chart, you need Helm version 3.9+ up to and including 3.19.5.

## Manual installation

Follow these steps to deploy the EDOT Collector and EDOT OTel SDKs in Kubernetes with ECH.
<stepper>
  <step title="Add the repository to Helm">
    Run the following command to add the charts repository to Helm:
    ```bash
    helm repo add open-telemetry "https://open-telemetry.github.io/opentelemetry-helm-charts" --force-update
    ```
  </step>

  <step title="Configure your credentials">
    Retrieve your Elasticsearch URL and your API key:
    1. Retrieve the Elasticsearch URL for your Elastic Cloud deployment:
       1. Go to the [Elastic Cloud console](https://cloud.elastic.co/).
    2. Next to your deployment, select **Manage**.
    3. Under **Applications** next to **Elasticsearch**, select **Copy endpoint**.
    2. Create an API Key following [these instructions](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys).
    Replace both the `<ELASTICSEARCH_ENDPOINT>` and `<ELASTIC_API_KEY>` placeholders in the following command to create a namespace and a secret with your credentials.
    ```bash
    kubectl create namespace opentelemetry-operator-system
    kubectl create secret generic elastic-secret-otel \
    --namespace opentelemetry-operator-system \
    --from-literal=elastic_endpoint='<ELASTICSEARCH_ENDPOINT>' \
    --from-literal=elastic_api_key='<ELASTIC_API_KEY>'
    ```

    <note>
      On Windows PowerShell, replace backslashes (`\`) with backticks (```) for line continuation and single quotes (`'`) with double quotes (`"`).
    </note>
  </step>

  <step title="Install the Operator">
    Install the OpenTelemetry Operator using the `kube-stack` Helm chart with the configured `values.yaml` file.
    ```bash
    helm install opentelemetry-kube-stack open-telemetry/opentelemetry-kube-stack \
    --namespace opentelemetry-operator-system \
    --values 'https://raw.githubusercontent.com/elastic/elastic-agent/refs/tags/v9.3.0/deploy/helm/edot-collector/kube-stack/values.yaml' \
    --version '0.12.4'
    ```
  </step>

  <step title="Auto-instrument applications">
    Add a language-specific annotation to your namespace by replacing `<LANGUAGE>` with one of the supported values: `nodejs`, `java`, `python`, `dotnet` or `go`:
    ```bash
    kubectl annotate namespace YOUR_NAMESPACE instrumentation.opentelemetry.io/inject-<LANGUAGE>="opentelemetry-operator-system/elastic-instrumentation"
    ```
    Restart your deployment to ensure the annotations and auto-instrumentations are applied.For languages where auto-instrumentation is not available, you need to manually instrument your application. See the [Setup section for the corresponding SDK](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks).
  </step>

  <step title="Install the content packs">
    Install the **[Kubernetes OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/kubernetes_otel)** and **[System OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/system_otel)** integrations in Kibana.
  </step>

  <step title="Explore your data">
    Go to Kibana and select **Dashboards** to explore your newly collected data.
  </step>
</stepper>


## Troubleshooting

Having issues with EDOT? Refer to the [Troubleshooting common issues with the EDOT Collector](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector) and [Troubleshooting the EDOT SDKs](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks) for help.