﻿---
title: Quickstart for hosts and VMs on Elastic Cloud Hosted
description: Learn how to set up the EDOT Collector and EDOT SDKs with Elastic Cloud Hosted to collect host metrics, logs and application traces.
url: https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/ech/hosts_vms
products:
  - Elastic Cloud Hosted
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
  - Elastic Cloud Hosted: Generally available
  - Elastic Distribution of OpenTelemetry Collector: Generally available
---

# Quickstart for hosts and VMs on Elastic Cloud Hosted
Learn how to set up the EDOT Collector and EDOT SDKs with Elastic Cloud Hosted (ECH) to collect host metrics, logs and application traces.

## Guided setup

Use the **Add data** screen in Elastic Observability to generate install commands that are already configured with the values you need.
1. Open Elastic Observability.
2. Go to **Add data**.
3. Select what you want to monitor.
4. Follow the instructions.


## Manual installation

Follow these steps to deploy the EDOT Collector and EDOT OTel SDKs with ECH.
<stepper>
  <step title="Download the EDOT Collector">
    [Download the EDOT Collector](https://www.elastic.co/docs/reference/edot-collector/download) for your operating system, extract the file, and change directory to the extracted files.
  </step>

  <step title="Configure the EDOT Collector">
    Retrieve your Elasticsearch URL and your API key:
    1. Retrieve the Elasticsearch URL for your Elastic Cloud deployment:
       1. Go to the [Elastic Cloud console](https://cloud.elastic.co/).
    2. Next to your deployment, select **Manage**.
    3. Under **Applications** next to **Elasticsearch**, select **Copy endpoint**.
    2. Create an API Key following [these instructions](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys).
    Replace `<ELASTICSEARCH_ENDPOINT>` and `<ELASTIC_API_KEY>` before applying the following commands.
    <tab-set>
      <tab-item title="Linux">
        ```bash
        ELASTICSEARCH_ENDPOINT=<ELASTICSEARCH_ENDPOINT> && \
        ELASTIC_API_KEY=<ELASTIC_API_KEY> && \
        cp ./otel_samples/logs_metrics_traces.yml ./otel.yml && \
        mkdir -p ./data/otelcol && \
        sed -i "s#\${env:STORAGE_DIR}#${PWD}/data/otelcol#g" ./otel.yml && \
        sed -i "s#\${env:ELASTIC_ENDPOINT}#${ELASTICSEARCH_ENDPOINT}#g" ./otel.yml && \
        sed -i "s#\${env:ELASTIC_API_KEY}#${ELASTIC_API_KEY}#g" ./otel.yml
        ```
      </tab-item>

      <tab-item title="macOS">
        ```bash
        ELASTICSEARCH_ENDPOINT=<ELASTICSEARCH_ENDPOINT> && \
        ELASTIC_API_KEY=<ELASTIC_API_KEY> && \
        cp ./otel_samples/logs_metrics_traces.yml ./otel.yml && \
        mkdir -p ./data/otelcol && \
        sed -i '' "s#\${env:STORAGE_DIR}#${PWD}/data/otelcol#g" ./otel.yml && \
        sed -i '' "s#\${env:ELASTIC_ENDPOINT}#${ELASTICSEARCH_ENDPOINT}#g" ./otel.yml && \
        sed -i '' "s#\${env:ELASTIC_API_KEY}#${ELASTIC_API_KEY}#g" ./otel.yml
        ```
      </tab-item>

      <tab-item title="Windows">
        ```powershell
        Remove-Item -Path .\otel.yml -ErrorAction SilentlyContinue
        Copy-Item .\otel_samples\logs_metrics_traces.yml .\otel.yml
        New-Item -ItemType Directory -Force -Path .\data\otelcol | Out-Null

        $content = Get-Content .\otel.yml
        $content = $content -replace '\${env:STORAGE_DIR}', "$PWD\data\otelcol"
        $content = $content -replace '\${env:ELASTIC_ENDPOINT}', "<ELASTICSEARCH_ENDPOINT>"
        $content = $content -replace '\${env:ELASTIC_API_KEY}', "<ELASTIC_API_KEY>"
        $content | Set-Content .\otel.yml
        ```
      </tab-item>
    </tab-set>
  </step>

  <step title="Run the EDOT Collector">
    Run the following command to run the EDOT Collector.
    <tab-set>
      <tab-item title="Linux and macOS">
        ```bash
        sudo ./otelcol --config otel.yml
        ```
      </tab-item>

      <tab-item title="Windows">
        ```powershell
        .\elastic-agent.exe otel --config otel.yml
        ```
      </tab-item>
    </tab-set>

    <note>
      By default, the Collector opens ports `4317` and `4318` to receive application data from locally running OTel SDKs.
    </note>
  </step>

  <step title="(Optional) Instrument your applications">
    To collect telemetry from applications and use the EDOT Collector as a gateway,
    instrument your target applications following the setup instructions:
    - [Android](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android)
    - [.NET](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/dotnet/setup)
    - [iOS](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios)
    - [Java](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java/setup)
    - [Node.js](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node/setup)
    - [PHP](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/php/setup)
    - [Python](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/setup)
    Configure your SDKs to send the data to the local EDOT Collector using OTLP/gRPC (`http://localhost:4317`) or OTLP/HTTP (`http://localhost:4318`).
    <tip>
      Activate Central Configuration to configure your EDOT SDKs from within Kibana. Refer to [EDOT SDKs Central Configuration](https://www.elastic.co/docs/reference/opentelemetry/central-configuration).
    </tip>
  </step>

  <step title="Install the content pack">
    Install the **[System OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/system_otel)** integration in Kibana.
  </step>

  <step title="Explore your data">
    Go to Kibana and select **Dashboards** to explore your newly collected data.
  </step>
</stepper>


## Troubleshooting

Having issues with EDOT? Refer to the [Troubleshooting common issues with the EDOT Collector](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector) and [Troubleshooting the EDOT SDKs](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks) for help.