﻿---
title: Quickstart for Docker on Elastic Cloud Hosted
description: Learn how to set up the EDOT Collector and EDOT SDKs in a Docker environment with Elastic Cloud Hosted to collect host metrics, logs and application traces.
url: https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/ech/docker
products:
  - Elastic Cloud Hosted
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
  - Elastic Cloud Hosted: Generally available
  - Elastic Distribution of OpenTelemetry Collector: Generally available
---

# Quickstart for Docker on Elastic Cloud Hosted
Learn how to set up the EDOT Collector and EDOT SDKs in a Docker environment with Elastic Cloud Hosted (ECH) to collect host metrics, logs, and application traces.

## Guided setup

Use the **Add data** screen in Elastic Observability to generate install commands that are already configured with the values you need.
1. Open Elastic Observability.
2. Go to **Add data**.
3. Select what you want to monitor.
4. Follow the instructions.


## Manual installation

Follow these steps to deploy the EDOT Collector and EDOT OTel SDKs in Docker with ECH.
<stepper>
  <step title="Create the config file">
    Create the `otel-collector-config.yml` file with your EDOT Collector configuration. Refer to the [configuration reference](https://www.elastic.co/docs/reference/edot-collector/config/default-config-standalone).
  </step>

  <step title="Retrieve your settings">
    Retrieve your Elasticsearch URL and your API key:
    1. Retrieve the Elasticsearch URL for your Elastic Cloud deployment:
       1. Go to the [Elastic Cloud console](https://cloud.elastic.co/).
    2. Next to your deployment, select **Manage**.
    3. Under **Applications** next to **Elasticsearch**, select **Copy endpoint**.
    2. Create an API Key following [these instructions](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys).
  </step>

  <step title="the .env file">
    Create an `.env` file with the following content. Replace the placeholder values with your Elastic Cloud credentials:
    ```bash
    HOST_FILESYSTEM=/
    DOCKER_SOCK=/var/run/docker.sock
    ELASTIC_AGENT_OTEL=true
    COLLECTOR_CONTRIB_IMAGE=elastic/elastic-agent:9.3.0
    ELASTIC_API_KEY=<your_api_key_here>
    ELASTIC_ENDPOINT=<your_endpoint_here>
    OTEL_COLLECTOR_CONFIG=/path/to/otel-collector-config.yml
    ```
  </step>

  <step title="Create the compose file">
    Create a `compose.yml` file with the following content:
    ```yaml
    services:
     otel-collector:
       image: ${COLLECTOR_CONTRIB_IMAGE}
       container_name: otel-collector
       deploy:
         resources:
           limits:
             memory: 1.5G
       restart: unless-stopped
       command: ["--config", "/etc/otelcol-config.yml" ]
       network_mode: host
       user: 0:0
       volumes:
         - ${HOST_FILESYSTEM}:/hostfs:ro
         - ${DOCKER_SOCK}:/var/run/docker.sock:ro
         - ${OTEL_COLLECTOR_CONFIG}:/etc/otelcol-config.yml
       environment:
         - HOST_FILESYSTEM
         - ELASTIC_API_KEY
         - ELASTIC_ENDPOINT
         - ELASTIC_AGENT_OTEL
         - STORAGE_DIR=/usr/share/elastic-agent
    ```
  </step>

  <step title="Start the Collector">
    Start the Collector by running:
    ```bash
    docker compose up -d
    ```
  </step>

  <step title="(Optional) Instrument your applications">
    To collect telemetry from applications and use the EDOT Collector as a gateway,
    instrument your target applications following the setup instructions:
    - [Android](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android)
    - [.NET](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/dotnet/setup)
    - [iOS](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios)
    - [Java](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java/setup)
    - [Node.js](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node/setup)
    - [PHP](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/php/setup)
    - [Python](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/setup)
    Configure your SDKs to send the data to the local EDOT Collector using OTLP/gRPC (`http://localhost:4317`) or OTLP/HTTP (`http://localhost:4318`).
    <tip>
      Activate Central Configuration to configure your EDOT SDKs from within Kibana. Refer to [EDOT SDKs Central Configuration](https://www.elastic.co/docs/reference/opentelemetry/central-configuration).
    </tip>
  </step>

  <step title="Install the content packs">
    Install the **[System OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/system_otel)** integration and the **[Docker OpenTelemetry Assets](https://www.elastic.co/docs/reference/integrations/docker_otel)** integration in Kibana.
  </step>

  <step title="Explore your data">
    Go to Kibana and select **Dashboards** to explore your newly collected data.
  </step>
</stepper>


## Troubleshooting

Having issues with EDOT? Refer to the [Troubleshooting common issues with the EDOT Collector](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector) and [Troubleshooting the EDOT SDKs](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks) for help.