﻿---
title: OpenTelemetry quickstarts
description: Learn how to set up the Elastic Distributions for OpenTelemetry (EDOT) to monitor Kubernetes, applications, and hosts. The guides cover installing the EDOT Collector, enabling auto-instrumentation, and configuring data collection for metrics, logs, and traces in Elastic Observability.
url: https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Collector: Generally available
---

# OpenTelemetry quickstarts
Learn how to set up the Elastic Distributions for OpenTelemetry (EDOT) to monitor Kubernetes, applications, and hosts.

## Add data from the UI

You can quickly add data from hosts, Kubernetes, applications, and cloud services from the Observability UI.
1. Open Elastic Observability.
2. Go to **Add data**.
3. Select what you want to monitor.
4. Follow the instructions.


## Manual installation guides

These guides cover how to install the EDOT Collector, turn on auto-instrumentation, and configure data collection for metrics, logs, and traces in Elastic Observability.
Select a guide based on the environment of your target system and your Elastic deployment model.

| Deployment Model           | Kubernetes                                                                                                                                 | Docker                                                                                                                                     | Hosts or VMs                                                                                                                                    |
|----------------------------|--------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------|
| Self-managed Elastic Stack | [Kubernetes on self-managed](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/self-managed/k8s)    | [Docker on self-managed](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/self-managed/docker)     | [Hosts or VMs on self-managed](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/self-managed/hosts_vms) |
| Elastic Cloud Serverless   | [Kubernetes on serverless](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/serverless/k8s)        | [Docker on serverless](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/serverless/docker)         | [Hosts or VMs on serverless](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/serverless/hosts_vms)     |
| Elastic Cloud Hosted       | [Kubernetes on hosted](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/ech/k8s)                   | [Docker on hosted](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/ech/docker)                    | [Hosts or VMs on hosted](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/ech/hosts_vms)                |
| Multiple                   | [Ingest custom metrics with EDOT](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/custom-metrics-quickstart) | [Ingest custom metrics with EDOT](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/custom-metrics-quickstart) | [Ingest custom metrics with EDOT](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/custom-metrics-quickstart)      |


## Troubleshooting

Having issues with the EDOT Collector? Refer to the [Troubleshooting common issues with the EDOT Collector](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-collector) guide for help.