﻿---
title: Get started with Elastic Observability Serverless Logs Essentials
description: New to Elastic Observability Serverless Logs Essentials? Discover more about its features and how to get started. The following instructions guide you...
url: https://www.elastic.co/docs/solutions/observability/get-started/logs-essentials
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
---

# Get started with Elastic Observability Serverless Logs Essentials
<note>
  Use this guide to get started with the Logs Essentials feature tier of Elastic Observability Serverless. Refer to the main [Observability getting started](https://www.elastic.co/docs/solutions/observability/get-started) docs to get started with Elastic Observability Serverless Complete, which includes APM and Infrastructure metrics. The [Elastic Observability Serverless feature tiers](https://www.elastic.co/docs/solutions/observability/observability-serverless-feature-tiers) page details the difference between tiers.
</note>

New to Elastic Observability Serverless Logs Essentials? Discover more about its features and how to get started. The following instructions guide you through setting up your first Elastic Observability Logs Essentials deployment, collecting log data, and exploring your data.

## Get started with your use case

Learn how to create an Elastic Observability Serverless project and use Elastic Observability to gain deeper insight into the behavior of your applications and systems.
<stepper>
  <step title="Create an Observability project">
    An Elastic Observability Serverless project allows you to run Elastic Observability Serverless in an autoscaled and fully-managed environment, where you don’t have to manage the underlying Elasticsearch cluster or Kibana instances.
    <dropdown title="Steps for creating a project">
      <note>
        The **Admin** role or higher is required to create projects. Refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/manage-users#general-assign-user-roles).
      </note>

      1. Navigate to [cloud.elastic.co](https://cloud.elastic.co/) and log in to your account, or create one.
      2. Select **Create serverless project**.
      3. Under **Elastic for Observability**, select **Next**.
      4. Enter a name for your project.
      5. Under **Product features**, select **Observability Logs Essentials**.
      6. (Optional) Under **Settings** you can change the following:
         - **Cloud provider**: The cloud platform where you’ll deploy your project. We currently support Amazon Web Services (AWS).
      - **Region**: The [region](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/regions) where your project will live.
      7. Select **Create serverless project**. It takes a few minutes to create your project.
      8. When the project is ready, click **Continue**.
    </dropdown>
  </step>

  <step title="Collect infrastructure logs">
    Bring logs from your hosts and services into Elastic Observability to monitor the health and performance of your infrastructure. You can collect this data from hosts, containers, Kubernetes, and Cloud services.
    <dropdown title="Steps for collecting infrastructure logs and metrics">
      <tab-set>
        <tab-item title="Hosts">
          Elastic Observability can collect logs from hosts through the Elastic Distribution of OpenTelemetry (EDOT) Collector or the Elastic Agent.
          1. Select **Add data** from the main menu and then select **Host**.
          2. Select one of these options:
             - **OpenTelemetry: Logs**: Collect native OpenTelemetry logs.
          - **Elastic Agent: Logs**: Bring data from Elastic integrations.
          3. Follow the instructions for your platform.
          For an overview of the EDOT, refer to [Elastic Distribution of OpenTelemetry (EDOT)](https://www.elastic.co/docs/reference/opentelemetry).
        </tab-item>

        <tab-item title="Kubernetes">
          Elastic Observability can collect logs from Kubernetes through the Elastic Distribution of OpenTelemetry (EDOT) Collector or the Elastic Agent.
          1. Select **Add data** from the main menu and then select **Kubernetes**.
          2. Select one of these options:
             - **OpenTelemetry: Logs**: Collect native OpenTelemetry metrics and logs.
          - **Elastic Agent: Logs**: Bring data from Elastic integrations.
          3. Follow the instructions for your platform.
          For an overview of EDOT, refer to [Elastic Distribution of OpenTelemetry (EDOT)](https://www.elastic.co/docs/reference/opentelemetry).
        </tab-item>

        <tab-item title="Cloud">
          Elastic Observability can collect logs from cloud services through Elastic integrations.
          1. Select **Add data** from the main menu and then select **Cloud**.
          2. Select your Cloud provider to view the collection of integrations available for that provider.
          3. Select the integration you want to add.
          4. Select **Add**.
        </tab-item>
      </tab-set>
    </dropdown>
  </step>

  <step title="Explore logs in Discover">
    **Discover** lets you quickly search and filter your log data, get information about the structure of your log fields, and display findings in a visualization. Instead of having to log into different servers, change directories, and view individual files, all your logs are available in a single view.For more information on exploring your logs in **Discover**, refer to [Explore logs in Discover](https://www.elastic.co/docs/solutions/observability/logs/discover-logs).
  </step>

  <step title="Create your first dashboards">
    Elastic provides a wide range of prebuilt dashboards for visualizing observability data from a variety of sources. These dashboards are loaded automatically when you install [Elastic integrations](https://docs.elastic.co/integrations). You can also create new dashboards and visualizations based on your data views.To create a new dashboard, select **Create Dashboard** and begin adding visualizations. You can create charts, graphs, maps, tables, and other types of visualizations from your data, or you can add visualizations from the library. You can also add other types of panels, such as filters and controls.For more information about creating dashboards, refer to [Create your first dashboard](https://www.elastic.co/docs/explore-analyze/dashboards/create-dashboard-of-panels-with-web-server-data).
  </step>

  <step title="Set up alerts">
    Elastic Observability lets you define rules of different types which detect complex conditions and trigger relevant actions. Elastic Observability can send alerts to email, Slack, and other third-party systems. Refer to [Create and manage rules for Elastic Observability](https://www.elastic.co/docs/solutions/observability/incident-management/create-manage-rules) to get started.
  </step>
</stepper>


## Related resources

Use these resources to learn more about Observability or get started in a different way.

### Quickstarts

Quickstarts are compact hands-on guides that help you experiment with Elastic Observability features. Each quickstart provides a highly opinionated, fast path to data ingestion, with minimal configuration required.
[Browse the Elastic Observability quickstarts](https://www.elastic.co/docs/solutions/observability/get-started/quickstarts) to get started with specific use cases.

### Observability integrations

Many Observability integrations are available to collect and process your data. Refer to [Elastic integrations](https://www.elastic.co/docs/reference/integrations) for more information.

### Other resources

- [What's Elastic Observability](https://www.elastic.co/docs/solutions/observability)
- [What’s new in Elastic Stack](https://www.elastic.co/docs/release-notes/observability)
- [Elastic Observability Serverless billing dimensions](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/elastic-observability-billing-dimensions)
- [Log monitoring](https://www.elastic.co/docs/solutions/observability/logs)