﻿---
title: Get started with Elastic Observability
description: New to Elastic Observability? Discover more about our observability features and how to get started. The following instructions guides you through setting...
url: https://www.elastic.co/docs/solutions/observability/get-started
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Get started with Elastic Observability
<note>
  Use this guide to get started with the Observability Complete feature tier of Elastic Observability Serverless. Refer to the [Logs Essentials getting started](https://www.elastic.co/docs/solutions/observability/get-started/logs-essentials) docs to get started with Elastic Observability Serverless Logs Essentials. The [Elastic Observability Serverless feature tiers](https://www.elastic.co/docs/solutions/observability/observability-serverless-feature-tiers) page details the difference between tiers.
</note>

New to Elastic Observability? Discover more about our observability features and how to get started. The following instructions guides you through setting up your first Elastic Observability deployment, collecting data from infrastructure and applications, and exploring your data.

## Get started with your use case

Learn how to create an Elastic Observability Serverless project and use Elastic Observability to gain deeper insight into the behavior of your applications and systems.
<stepper>
  <step title="Create an {{obs-serverless}} project">
    An Elastic Observability Serverless project allows you to run Elastic Observability Serverless in an autoscaled and fully-managed environment, where you don’t have to manage the underlying Elasticsearch cluster or Kibana instances.
    <dropdown title="Steps for creating a project">
      <note>
        The **Admin** role or higher is required to create projects. Refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/manage-users#general-assign-user-roles).
      </note>

      1. Navigate to [cloud.elastic.co](https://cloud.elastic.co/) and log in to your account, or create one.
      2. Select **Create serverless project**.
      3. Under **Elastic for Observability**, select **Next**.
      4. Enter a name for your project and select **Observability Complete**.
      5. (Optional) Select **Edit settings** to change your project settings:
         - **Cloud provider**: The cloud platform where you’ll deploy your project. We currently support Amazon Web Services (AWS).
      - **Region**: The [region](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/regions) where your project will live.
      6. Select **Create project**. It takes a few minutes to create your project.
      7. When the project is ready, click **Continue**.
    </dropdown>

    <note>
      For other types of deployments, refer to [Deploy](https://www.elastic.co/docs/deploy-manage/deploy). For a breakdown of the differences between deployment types and what they support, refer to [Detailed deployment comparison](https://www.elastic.co/docs/deploy-manage/deploy/deployment-comparison).
    </note>
  </step>

  <step title="Collect infrastructure logs and metrics">
    Bring logs and metrics from your hosts and services into Elastic Observability to monitor the health and performance of your infrastructure. You can collect this data from hosts, containers, Kubernetes, and Cloud services.
    <dropdown title="Steps for collecting infrastructure logs and metrics">
      <tab-set>
        <tab-item title="Hosts">
          Elastic Observability can collect telemetry data from hosts, containers, and Kubernetes through the EDOT Collector or the Elastic Agent.
          1. Select **Add data** from the main menu and then select **Host**.
          2. Select one of these options:
             - **OpenTelemetry: Full Observability**: Collect native OpenTelemetry metrics and logs.
          - **Elastic Agent: Logs & Metrics**: Bring data from Elastic integrations.
          3. Follow the instructions for your platform.
          For an overview of the Elastic Distribution of OpenTelemetry Collector, refer to [Elastic Distribution of OpenTelemetry (EDOT)](https://www.elastic.co/docs/reference/opentelemetry).
        </tab-item>

        <tab-item title="Kubernetes">
          Elastic Observability can collect telemetry data from Kubernetes through the Elastic Distribution of OpenTelemetry Collector or the Elastic Agent.
          1. Select **Add data** from the main menu and then select **Kubernetes**.
          2. Select one of these options:
             - **OpenTelemetry: Full Observability**: Collect native OpenTelemetry metrics and logs.
          - **Elastic Agent: Logs & Metrics**: Bring data from Elastic Integrations.
          3. Follow the instructions for your platform.
          For an overview of EDOT, refer to [Elastic Distribution of OpenTelemetry (EDOT)](https://www.elastic.co/docs/reference/opentelemetry).
        </tab-item>

        <tab-item title="Integrations">
          Elastic Observability can collect telemetry data from services through Elastic Integrations.
          1. Select **Add data** from the main menu.
          2. In **Search through other ways of ingesting data**, enter the name of an integration (for example, NGINX).
          3. Select the integration you want to add.
          4. Select **Add**.
        </tab-item>

        <tab-item title="Cloud">
          Elastic Observability can collect telemetry data from cloud services through Elastic Integrations.
          1. Select **Add data** from the main menu and then select **Cloud**.
          2. Select your Cloud provider to view the collection of integrations available for that provider.
          3. Select the integration you want to add.
          4. Select **Add**.
        </tab-item>

        <tab-item title="CI/CD">
          Elastic Observability can collect telemetry data from CI/CD pipelines using OpenTelemetry.Refer to [CI/CD](https://www.elastic.co/docs/solutions/observability/cicd) for more information.
        </tab-item>

        <tab-item title="LLMs">
          Elastic provides a powerful LLM observability framework including key metrics, logs, and traces, along with pre-configured, out-of-the-box dashboards that deliver deep insights into model prompts and responses, performance, usage, and costs.Refer to [LLM observability](https://www.elastic.co/docs/solutions/observability/applications/llm-observability) for more information.
        </tab-item>
      </tab-set>
    </dropdown>
  </step>

  <step title="Collect application traces, metrics, and logs">
    Bring traces, logs, and metrics into Elastic APM to help you troubleshoot and optimize your applications. You can collect this data using OpenTelemetry or APM Server.
    <dropdown title="Steps for collecting application traces, metrics, and logs">
      <tab-set>
        <tab-item title="OpenTelemetry">
          The [Elastic Distribution of OpenTelemetry Collector SDKs](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks) facilitate the collection of traces, metrics, and logs in OpenTelemetry format into Elastic APM.
          1. Select **Add data** from the main menu and then select **Application**.
          2. Select **OpenTelemetry**.
          3. Follow the instructions for your platform.
        </tab-item>

        <tab-item title="APM agents">
          Use the [APM agents](https://www.elastic.co/docs/solutions/observability/apm/apm-agents) to collect traces, metrics, and logs through APM Server or the managed intake service.
          1. Select **Add data** from the main menu and then select **Application**.
          2. Select **Elastic APM**.
          3. Select the tab for your language or framework.
          4. Follow the instructions in the tab.
        </tab-item>
      </tab-set>
    </dropdown>
  </step>

  <step title="Add Synthetics monitoring">
    [Synthetics monitoring](https://www.elastic.co/docs/solutions/observability/synthetics) lets you simulate, track, and visualize user journeys to catch performance, availability, and functionality issues in your services and applications. It periodically checks the status of your services and applications.
    <dropdown title="Steps for adding Synthetics monitoring">
      1. Select **Add data** from the main menu and then select **Application**.
      2. Select **Synthetic monitor**.
      3. Select a [monitor type](https://www.elastic.co/docs/solutions/observability/synthetics).
      4. Fill out the details.
      5. (Optional) Add a [Playwright](https://playwright.dev/) script.
      6. Test and create your monitor.
    </dropdown>
  </step>

  <step title="Explore your logs, metrics, and traces">
    After you've onboarded your data, you can explore it in the following Elastic Observability UIs, or query it using [query languages](https://www.elastic.co/docs/reference/query-languages).
    - [Explore your logs](https://www.elastic.co/docs/solutions/observability/logs/explore-logs) in the Logs UI.
    - [Analyze infrastructure and host metrics](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics) in the Infrastructure UI.
    - [View and analyze APM data](https://www.elastic.co/docs/solutions/observability/apm/view-analyze-data) in the Applications UI.
    - Use the [Elastic Query Language (ES|QL)](https://www.elastic.co/docs/explore-analyze/discover/try-esql) to search and filter your data.
  </step>

  <step title="Create your first dashboards">
    Elastic provides a wide range of prebuilt dashboards for visualizing observability data from a variety of sources. These dashboards are loaded automatically when you install [Elastic Integrations](https://docs.elastic.co/integrations). You can also create new dashboards and visualizations based on your data views.To create a new dashboard, select **Create Dashboard** and begin adding visualizations. You can create charts, graphs, maps, tables, and other types of visualizations from your data, or you can add visualizations from the library. You can also add other types of panels, such as filters and controls.For more information about creating dashboards, refer to [Create your first dashboard](https://www.elastic.co/docs/explore-analyze/dashboards/create-dashboard-of-panels-with-web-server-data).
  </step>

  <step title="Set up alerts and SLOs">
    Elastic Observability lets you define rules of different types which detect complex conditions and trigger relevant actions. Observability can send alerts to email, Slack, and other third-party systems. Refer to [Create and manage rules for Elastic Observability](https://www.elastic.co/docs/solutions/observability/incident-management/create-manage-rules) for more information.Observability also lets you define Service Level Objectives (SLOs) to set clear, measurable targets for your service performance, based on factors like availability, response times, error rates, and other key metrics. Refer to [Create and manage SLOs](https://www.elastic.co/docs/solutions/observability/incident-management/service-level-objectives-slos) to get started.
  </step>
</stepper>


## Related resources

Use these resources to learn more about Observability or get started in a different way.

### Quickstarts

Quickstarts are compact hands-on guides that help you experiment with Observability features. Each quickstart provides a highly opinionated, fast path to data ingestion, with minimal configuration required.
[Browse the Elastic Observability quickstarts](https://www.elastic.co/docs/solutions/observability/get-started/quickstarts) to get started with specific use cases.

### Observability integrations

Many [Observability integrations](https://www.elastic.co/integrations/data-integrations?solution=observability) are available to collect and process your data. Refer to [Elastic integrations](https://www.elastic.co/docs/reference/integrations) for more information.

### Other resources

- [What's Elastic Observability](https://www.elastic.co/docs/solutions/observability)
- [What's new in Elastic Stack](https://www.elastic.co/docs/release-notes/observability)
- [Elastic Observability Serverless billing dimensions](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/elastic-observability-billing-dimensions)