﻿---
title: Monitor Microsoft Azure with Elastic Agent
description: In this tutorial, you’ll learn how to deploy Elastic Agent and monitor your Azure infrastructure with Elastic Observability. You’ll learn how to: Create...
url: https://www.elastic.co/docs/solutions/observability/cloud/monitor-microsoft-azure-with-elastic-agent
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Monitor Microsoft Azure with Elastic Agent
<note>
  **New to Elastic?** Follow the steps in our [getting started guide](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-monitor-hosts-with-elastic-agent) instead of the steps described here. Return to this tutorial after you’ve learned the basics.**Using the native Azure integration from the marketplace?** Refer to [Monitor Microsoft Azure with the Azure Native ISV Service](https://www.elastic.co/docs/solutions/observability/cloud/monitor-microsoft-azure-with-azure-native-isv-service).
</note>

In this tutorial, you’ll learn how to deploy Elastic Agent and monitor your Azure infrastructure with Elastic Observability.

## What you’ll learn

You’ll learn how to:
- Create an Azure service principal with permissions to read monitoring data.
- Collect Azure billing metrics.
- Collect Azure activity logs.
- Visualize the logs and infrastructure metrics in Kibana.


## Step 1: Create an Azure service principal

In this step, you create an Azure service principal and then grant them access to use the Azure REST API.
The [Azure REST API](https://learn.microsoft.com/en-us/rest/api/azure/) allows you to get insights into your Azure resources using different operations. To access the Azure REST API, you need to use the Azure Resource Manager authentication model. Therefore, you must authenticate all requests with Azure Active Directory (Azure AD). You can create the service principal using the [Azure portal](https://docs.microsoft.com/en-us/azure/active-directory/develop/howto-create-service-principal-portal) or [Azure PowerShell](https://docs.microsoft.com/en-us/powershell/azure/create-azure-service-principal-azureps?view=azps-2.7.0). Then, you need to grant access permission, which is detailed [here](https://docs.microsoft.com/en-us/azure/role-based-access-control/built-in-roles). This tutorial shows how to use the Azure portal.

### Create an Azure service principal

1. Go to the [Microsoft Azure Portal](https://portal.azure.com/). Search for and select **Azure Active Directory**.
2. In the navigation pane, select **App registrations** and then click **New registration**.
3. Type the name of your application (this tutorial uses `ingest-tutorial-monitor-azure`) and click **Register** (accept the default values for other settings).
   ![Screenshot of the application registration](https://www.elastic.co/docs/solutions/images/observability-agent-tut-azure-register-app.png)
   Copy the **Application (client) ID** and save it for later. This ID is required to configure Elastic Agent to connect to your Azure account.
4. In the navigation pane, select **Certificates & secrets**, and then click **New client secret** to create a new security key.
   ![Screenshot of adding a new client secret](https://www.elastic.co/docs/solutions/images/observability-agent-tut-azure-click-client-secret.png)
5. Type a description of the secret and select an expiration. Click **Add** to create the client secret. Under **Value**, copy the secret value and save it (along with your client ID) for later.
   <important>
   This is your only chance to copy the secret value. You can’t retrieve this value after you leave this page!
   </important>


### Grant access permission for your service principal

After creating the Azure service principal, you need to grant it the correct permissions. You need the `Billing Reader` role to configure Elastic Agent to collect billing metrics.
1. In the Azure Portal, search for and select **Subscriptions**.
2. In the Subscriptions page, click the name of your subscription.
3. In the navigation pane, select **Access control (IAM)**.
4. Click **Add** and select **Add role assignment**.
5. On the **Roles** tab, select the **Billing Reader** role, then click **Next**.
6. On the **Members** tab, select the option to assign access to **User, group, or service principal**.
7. Click **Select members**, then search for and select the principal you created earlier.
8. For the description, enter the name of your service principal.
9. Click **Next** to review the role assignment:
   ![Screen capture of adding a role assignment](https://www.elastic.co/docs/solutions/images/observability-agent-tut-azure-add-role-assignment.png)
10. Click **Review + assign** to grant the service principal access to your subscription.


## Step 2: Install the Azure Billing Metrics integration

In this step, you install the Azure Billing Metrics integration in Kibana. This integration contains an input for collecting metrics, such as Azure usage details and forecast information, about your subscription.
To add the integration:
1. Find **Integrations** in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. In the query bar, search for **Azure Billing** and select the Azure Billing Metrics integration to see more details about it.
3. Click **Add Azure Billing Metrics**.
4. Under Integration settings, configure the integration name and optionally add a description.
   <tip>
   If you don’t see options for configuring the integration, you’re probably in a workflow designed for new deployments. Follow the steps, then return to this tutorial when you’re ready to configure the integration.
   </tip>
5. Specify values for all the required fields. For more information about these settings, refer to the [Azure Billing Metrics](https://docs.elastic.co/en/integrations/azure_billing) documentation.
   <definitions>
   <definition term="Client ID">
   The Application (client) ID that you copied earlier when you created the service principal.
   </definition>
   <definition term="Client secret">
   The secret value that you copied earlier.
   </definition>
   <definition term="Tenant ID">
   The tenant ID listed on the main Azure Active Directory Page.
   </definition>
   <definition term="Subscription ID">
   The subscription ID listed on the main Subscriptions page.
   ![Screenshot of integration settings for Azure](https://www.elastic.co/docs/solutions/images/observability-agent-tut-azure-integration-settings.png)
   </definition>
   </definitions>
6. Make sure the **Collect Azure Billing metrics** selector is turned on.
7. Accept the defaults to create a new agent policy.
8. Click **Save and continue**. This step takes a minute or two to complete. When it’s done, you’ll have an agent policy that contains the Azure configuration you just specified.

A popup should appear that prompts you to **Add Elastic Agent to your hosts**.

## Step 3: Install and run an Elastic Agent on your machine

<important>
  To get support for the latest API changes from Azure, we recommend that you use the latest in-service version of Elastic Agent compatible with your Elastic Stack. Otherwise your integrations may not function as expected.
</important>

You can install Elastic Agent on any host that can access the Azure account and forward events to Elasticsearch.
1. In the popup, click **Add Elastic Agent to your hosts** to open the **Add agent** flyout.
   <tip>
   If you accidentally closed the popup, go to **Fleet → Agents**, then click **Add agent** to access the installation instructions.
   </tip>
   The **Add agent** flyout has two options: **Enroll in Fleet** and **Run standalone**. The default is to enroll the agents in Fleet, as this reduces the amount of work on the person managing the hosts by providing a centralized management tool in Kibana.
2. The enrollment token you need should already be selected.
   <note>
   The enrollment token is specific to the Elastic Agent policy that you just created. When you run the command to enroll the agent in Fleet, you will pass in the enrollment token.
   </note>
3. To download, install, and enroll the Elastic Agent, select your host operating system and copy the installation command shown in the instructions.
4. Run the command on the host where you want to install Elastic Agent.

It takes a few minutes for Elastic Agent to enroll in Fleet, download the configuration specified in the policy, and start collecting data. You can wait to confirm incoming data, or close the window.

## Step 4: Visualize Azure billing metrics

Now that the metrics are streaming to Elasticsearch, you can visualize them in Kibana. Find **Dashboards** in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Search for Azure Billing and select the dashboard called **[Azure Billing] Billing Overview**.
![Screenshot of Azure billing overview dashboard](https://www.elastic.co/docs/solutions/images/observability-agent-tut-azure-billing-dashboard.png)

Keep in mind Elastic Agent collects data every 24 hours.

## Step 5: Collect Azure activity logs

Azure activity logs provide insight into the operations performed on resources in your subscription, such as when and who modified resources, and when virtual machines were started (or failed to start).
In this step, you configure Azure to export activity logs to an Azure event hub, then you configure the Azure Logs integration to read logs from the event hub and send them to Elasticsearch.

### Create an event hub for your logs

[Azure Event Hubs](https://learn.microsoft.com/en-us/azure/event-hubs/event-hubs-about) is a data streaming platform and event ingestion service that you use to store in-flight Azure logs before sending them to Elasticsearch. For this tutorial, you create a single event hub because you are collecting logs from one service: the Azure Monitor service.
To create an Azure event hub:
1. Go to the Azure portal.
2. Search for and select **Event Hubs**.
3. Click **Create** and create a new Event Hubs namespace. You’ll need to create a new resource group, or choose an existing one.
4. Enter the required settings for the namespace and click **Review + create**.
   ![Screenshot of window for creating an event hub namespace](https://www.elastic.co/docs/solutions/images/observability-agent-tut-azure-create-eventhub.png)
5. Click **Create** to deploy the resource.
6. In the new namespace, click **+ Event Hub** and enter a name for the event hub.
7. Click **Review + create**, and then click **Create** to deploy the resource.
8. Make a note of the namespace and event hub name because you will need them later.

<note>
  **When do I need more than one event hub?**Typically you create an event hub for each service you want to monitor. For example, imagine that you want to collect activity logs from the Azure Monitor service plus signin and audit logs from the Active Directory service. Rather than sending all logs to a single event hub, you create an event hub for each service:
  ![Diagram that shows an event hub for Active Directory logs and an event hub for activity logs](https://www.elastic.co/docs/solutions/images/observability-agent-tut-azure-event-hub-diagram.png)
  This setup is more efficient than using a single event hub for all logs because it:
  - Ensures that you publish only the logs expected by the downstream integration.
  - Saves bandwidth and compute resources because inputs only need to process relevant logs, rather than processing all the logs for all your monitored services, then discarding unneeded logs.
  - Avoids duplicates that might result from multiple inputs inadvertently reading and processing the same logs.
  For high-volume deployments, you might even want to have a dedicated event hub for each data stream.
</note>


### Configure diagnostic settings to send logs to the event hub

Every Azure service that creates logs has diagnostic settings that allow you to export logs and metrics to an external destination. In this step, you configure the Azure Monitor service to export activity logs to the event hub you created earlier.
To configure diagnostic settings for the Azure Monitor service:
1. Go to the Azure portal and go to **Home → Monitor**.
2. In the navigation page, select **Activity log**, and then click **Export Activity Logs**.
3. Select your subscription and click **Add diagnostic setting**.
4. Enter a name for the diagnostic setting.
5. In the list of log categories, select the logs you want to export.
6. Under Destination details, select **Stream to an event hub** and select the namespace and event hub you created earlier. For example:
   ![Screenshot of Azure diagnostic settings showing Administrative](https://www.elastic.co/docs/solutions/images/observability-agent-tut-azure-log-categories.png)
7. Save the diagnostic settings.


### Configure the Azure Logs integration to collect activity logs

Now that activity logs are streaming into the event hub, you can configure the Azure activity log integration to ingest the logs.
To add the integration:
1. Find **Integrations** in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. In the query bar, search for **Azure activity logs** and select the Azure activity logs integration to see more details about it.
3. Click **Add Azure activity logs**.
4. Under Integration settings, configure the integration name and optionally add a description.
5. Specify values for all the required fields. For more information about these settings, refer to the [Azure activity logs](https://docs.elastic.co/en/integrations/azure/activitylogs) documentation.
   <definitions>
   <definition term="Eventhub">
   The name of the event hub you created earlier.
   </definition>
   <definition term="Connection String">
   The connection string primary key of the event hub namespace. To learn how to get the connection string, refer to [Get an Event Hubs connection string](https://learn.microsoft.com/en-us/azure/event-hubs/event-hubs-get-connection-string) in the Azure documentation.
   <tip>
   Instead of copying the connection string from the RootManageSharedAccessKey policy, you should create a new shared access policy (with permission to listen) and copy the connection string from the new policy.
   </tip>
   </definition>
   </definitions>
   <definitions>
   <definition term="Storage account">
   The name of a blob storage account that Elastic Agent can use to store information about logs consumed by the agent. You can use the same storage account container for all integrations.
   </definition>
   <definition term="Storage account key">
   A valid access key defined for the storage account.
   ![Screenshot of integration settings for Azure activity logs](https://www.elastic.co/docs/solutions/images/observability-agent-tut-azure-activity-log-settings.png)
   </definition>
   </definitions>
6. Make sure the **Collect Azure activity logs from Event Hub** selector is turned on.
7. Under **Existing hosts**, select the agent policy that created earlier.
8. Save and deploy the integration.
   This step takes a minute or two to complete. When it’s done, you’ll have an agent policy that contains the Azure activity logs configuration plus the billing metrics configuration. The deployed Elastic Agent will pick up the policy change and start sending Azure activity logs to Elasticsearch.


## Step 5: Visualize Azure activity logs

Now that logs are streaming into Elasticsearch, you can visualize them in Kibana. To see the raw logs, find **Discover** in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Notice that you can filter on a specific data stream. For example, you can use `data_stream.dataset : "azure.activitylogs"` to show Azure activity logs.
The Azure activity logs integration also comes with pre-built dashboards that you can use to visualize the data. In Kibana, open the main menu and click **Dashboard**. Search for Azure activity and select the dashboard called **[Logs Azure] User Activity**:
![Screenshot of Azure activity logs dashboard](https://www.elastic.co/docs/solutions/images/observability-agent-tut-azure-activity-logs-dashboard.png)

Congratulations! You have completed the tutorial.