﻿---
title: Monitor Microsoft Azure with the Azure Native ISV Service
description: In this tutorial, you’ll learn how to: Create an Elasticsearch resource in the Azure portal.Ingest Azure platform logs using the Azure Native ISV Service.Ingest...
url: https://www.elastic.co/docs/solutions/observability/cloud/monitor-microsoft-azure-with-azure-native-isv-service
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Monitor Microsoft Azure with the Azure Native ISV Service
<note>
  The Elastic Cloud Azure Native ISV Service allows you to deploy managed instances of the Elastic Stack directly in Azure, through the Azure integrated marketplace. The service includes native capabilities for consolidating Azure logs and metrics in Elastic. For more information, refer to [Azure Native ISV Service](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/azure-native-isv-service).**Using Elastic Agent to monitor Azure?** Refer to [Monitor Microsoft Azure with Elastic Agent](https://www.elastic.co/docs/solutions/observability/cloud/monitor-microsoft-azure-with-elastic-agent).
</note>

In this tutorial, you’ll learn how to:
- Create an Elasticsearch resource in the Azure portal.
- Ingest Azure platform logs using the Azure Native ISV Service.
- Ingest logs and metrics from your virtual machines.
- Visualize the logs and metrics in Kibana.

<tip>
  The full product name in the Azure integrated marketplace is `Elastic Cloud (Elasticsearch) - An Azure Native ISV Service`.
</tip>


## Step 1: Create an Elasticsearch resource in the Azure portal

<important>
  These steps will not work if you have an active GCP or AWS deployment in Elastic Cloud that is already associated with the email address used for your Azure account. To avoid this problem, delete your GCP and AWS deployments in Elastic Cloud, or use a different Azure account. If this does not resolve your issue, reach out to us at `support@elastic.co`.
</important>

Microsoft Azure allows you to find, deploy, and manage Elasticsearch from within the Azure portal. The Azure Native ISV Service makes it faster and easier for you to experience the value of Elastic in your Azure environment. Behind the scenes, this process provisions a marketplace subscription with Elastic Cloud.

### Create an Elasticsearch resource

1. Log in to the [Azure portal](https://portal.azure.com/).
   <note>
   Ensure your Azure account is configured with **Owner** access on the subscription you want to use to deploy Elasticsearch. To learn more about Azure subscriptions, refer to the [Microsoft Azure documentation](https://docs.microsoft.com/en-us/azure/cost-management-billing/manage/add-change-subscription-administrator#assign-a-subscription-administrator).
   </note>
2. In the search bar, enter **Elastic Cloud (Elasticsearch)** and then select **Elastic Cloud (Elasticsearch) – An Azure Native ISV Service**.
3. Click **Create**.
4. Enter the **Subscription**, **Resource group**, and the **Resource name**.
5. Select an Elasticsearch version.
6. Select a region and then click **Review + create**.
   <note>
   Don’t change any settings under Logs & metrics yet. We will cover logs and infrastructure metrics later in this tutorial.
   </note>
   ![Screenshot of Elastic resource creation in Azure](https://www.elastic.co/docs/solutions/images/observability-monitor-azure-native-create-elastic-resource.png)
7. To create the Elasticsearch deployment, click **Create**.
8. After deployment is complete, click **Go to resource**. Here you can view and configure your deployment details. To access the cluster, click **Kibana**.
   ![Screenshot of deployment details for Elastic resource in Azure](https://www.elastic.co/docs/solutions/images/observability-monitor-azure-native-elastic-deployment.png)
9. Click **Accept** (if necessary) to grant permissions to use your Azure account, then log in to Elastic Cloud using your Azure credentials as a single sign-on.
10. To look for available data, click **Observability**. There should be no data yet. Next, you’ll ingest logs.


## Step 2: Ingest logs by using the Azure Native ISV Service

To ingest Azure subscription and resource logs into Elastic, you use the Azure Native ISV Service.
1. In the Azure portal, go to your Elasticsearch resource page and click **Ingest logs and metrics from Azure Services**.
2. Under **Logs**, select both checkboxes to collect subscription activity logs and Azure resource logs. Click **Save**.
   ![Screenshot of logs and metrics configuration for Elastic resource in Azure](https://www.elastic.co/docs/solutions/images/observability-monitor-azure-native-elastic-config-logs-metrics.png)
   <note>
   This configuration can also be applied during the Elastic resource creation. To make the concepts clearer, this tutorial separates the two steps.
   </note>
   <note>
   Native metrics collection for Azure services is not fully supported yet. To learn how to collect metrics from Azure services, refer to [Monitor Microsoft Azure with Elastic Agent](https://www.elastic.co/docs/solutions/observability/cloud/monitor-microsoft-azure-with-elastic-agent).
   </note>
3. In Kibana, under **Observability**, find **Overview** in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Refresh the page until you see some data. This may take a few minutes.
4. To analyze your subscription and resource logs, click **Show Logs**.


## Step 3: Ingest logs and metrics from your virtual machines (VMs)

1. In the Azure portal, go to your Elasticsearch resource and click **Virtual machines**.
2. Select the VMs that you want to collect logs and metrics from, click **Install Extension**, and then click **OK**.
   ![Screenshot that shows VMs selected for logs and metrics collection](https://www.elastic.co/docs/solutions/images/observability-monitor-azure-native-elastic-vms.png)
3. Wait until the extension is installed and sending data (if the list does not update, click **Refresh** ).
4. Back in Kibana, view the **Discover** again. Notice that you can filter the view to show logs for a specific instance, for example `cloud.instance.name : "ingest-tutorial-linux"`.
5. To view VM metrics, go to **Infrastructure inventory** and then select a VM. (To open **Infrastructure inventory**, find **Infrastructure** in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).)
   To explore the data further, click **Open as page**.

Congratulations! You have completed the tutorial.