﻿---
title: Monitor AWS Network Firewall logs
description: In this section, you’ll learn how to send AWS Network Firewall log events from AWS to your Elastic stack using Amazon Data Firehose. You will go through...
url: https://www.elastic.co/docs/solutions/observability/cloud/monitor-aws-network-firewall-logs
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Monitor AWS Network Firewall logs
In this section, you’ll learn how to send AWS Network Firewall log events from AWS to your Elastic stack using Amazon Data Firehose.
You will go through the following steps:
- Select a AWS Network Firewall-compatible resource
- Create a delivery stream in Amazon Data Firehose
- Set up logging to forward the logs to the Elastic stack using a Firehose stream
- Visualize your logs in Kibana


## Before you begin

We assume that you already have:
- An AWS account with permissions to pull the necessary data from AWS.
- An [Elastic Cloud Hosted](https://cloud.elastic.co/registration?page=docs&placement=docs-body) deployment. The deployment includes an Elasticsearch cluster for storing and searching your data, and Kibana for visualizing and managing your data. AWS Data Firehose works with Elastic Stack version 7.17 or greater, running on Elastic Cloud only.

<important>
  AWS PrivateLink is not supported. Make sure the deployment is on AWS, because the Amazon Data Firehose delivery stream connects specifically to an endpoint that needs to be on AWS.
</important>


## Step 1: Install AWS integration in Kibana

1. Find **Integrations** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Browse the catalog to find the AWS integration.
3. Navigate to the **Settings** tab and click **Install AWS assets**.


## Step 2: Select a resource

![AWS Network Firewall](https://www.elastic.co/docs/solutions/images/observability-firehose-networkfirewall-firewall.png)

You can either use an existing AWS Network Firewall, or create a new one for testing purposes.
Creating a Network Firewall is not trivial and is beyond the scope of this guide. For more information, check the AWS documentation on the [Getting started with AWS Network Firewall](https://docs.aws.amazon.com/network-firewall/latest/developerguide/getting-started.html) guide.

## Step 3: Create a stream in Amazon Data Firehose

![Firehose stream](https://www.elastic.co/docs/solutions/images/observability-firehose-networkfirewall-stream.png)

1. Go to the [AWS console](https://console.aws.amazon.com/) and navigate to Amazon Data Firehose.
2. Click **Create Firehose stream** and choose the source and destination of your Firehose stream. Set source to `Direct PUT` and destination to `Elastic`.
3. Collect Elasticsearch endpoint and API key from your deployment on Elastic Cloud.
   - **To find the Elasticsearch endpoint URL**:
  1. Go to the [Elastic Cloud](https://cloud.elastic.co/) console
2. Find your deployment in the **Hosted deployments** card and select **Manage**.
3. Under **Applications** click **Copy endpoint** next to **Elasticsearch**.
4. Make sure the endpoint is in the following format: `https://<deployment_name>.es.<region>.<csp>.elastic-cloud.com`.
- **To create the API key**:
  1. Go to the [Elastic Cloud](https://cloud.elastic.co/) console
2. Select **Open Kibana**.
3. Open the **API keys** management page in the navigation menu or using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), then click **Create API key**. If you are using an API key with **Restrict privileges**, make sure to review the Indices privileges to provide at least `auto_configure` and `write` permissions for the indices you will be using with this delivery stream.
4. Set up the delivery stream by specifying the following data:
   - Elastic endpoint URL: The URL that you copied in the previous step.
- API key: The API key that you created in the previous step.
- Content encoding: To reduce the data transfer costs, use GZIP encoding.
- Retry duration: A duration between 60 and 300 seconds should be suitable for most use cases.
- Backup settings: It is recommended to configure S3 backup for failed records. These backups can then be used to restore failed data ingestion caused by unforeseen service outages.

The Firehose stream is ready to send logs to our Elastic Cloud deployment.

## Step 4: Enable logging

![AWS Network Firewall logging](https://www.elastic.co/docs/solutions/images/observability-firehose-networkfirewall-logging.png)

The AWS Network Firewall logs have built-in logging support. It can send logs to Amazon S3, Amazon CloudWatch, and Amazon Kinesis Data Firehose.
To enable logging to Amazon Data Firehose:
1. In the AWS console, navigate to the AWS Network Firewall service.
2. Select the firewall for which you want to enable logging.
3. In the **Logging** section, click **Edit**.
4. Select the **Send logs to** option and choose **Kinesis Data Firehose**.
5. Select the Firehose stream you created in the previous step.
6. Click **Save**.

At this point, the Network Firewall will start sending logs to the Firehose stream.

## Step 5: Visualize your Network Firewall logs in Kibana

![Firehose monitor Network Firewall logs](https://www.elastic.co/docs/solutions/images/observability-firehose-networkfirewall-data-stream.png)

With the new logging settings in place, the Network Firewall starts sending log events to the Firehose stream.
Navigate to Kibana and choose **Visualize your logs with Discover**.
![Visualize Network Firewall logs with Discover](https://www.elastic.co/docs/solutions/images/observability-firehose-networkfirewall-discover.png)