﻿---
title: Monitor Amazon Simple Queue Service (SQS)
description: Amazon Simple Queue Service (SQS) is a message queuing service that allows your application components to communicate asynchronously through messages,...
url: https://www.elastic.co/docs/solutions/observability/cloud/monitor-amazon-simple-queue-service-sqs
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Monitor Amazon Simple Queue Service (SQS)
[Amazon Simple Queue Service (SQS)](https://aws.amazon.com/sqs/) is a message queuing service that allows your application components to communicate asynchronously through messages, making it easier to decouple and scale microservices, distributed systems, and serverless applications.
AWS SQS and Amazon CloudWatch are integrated and therefore, you can collect, view, and analyze data. Metrics for Amazon SQS queues are automatically collected and pushed to CloudWatch at one-minute intervals.
You can view and analyze the queue’s metrics from the Amazon SQS console, the CloudWatch console, the AWS CLI, or by using the CloudWatch API.
The Elastic [Amazon SQS integration](https://docs.elastic.co/en/integrations/aws/sqs) collects metrics from Amazon CloudWatch using Elastic Agent.

## Get started

To collect SQS metrics, you typically need to install the Elastic [Amazon SQS integration](https://docs.elastic.co/en/integrations/aws/sqs) and deploy an Elastic Agent locally or on an EC2 instance.
Expand the **quick guide** to learn how, or skip to the next section if your data is already in Elasticsearch.
<dropdown title="Quick guide: Add data">
  1. In the Observability UI, find **Integrations** in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
  2. In the query bar, search for and select the **Amazon SQS** integration.
  3. Read the overview to make sure you understand integration requirements and other considerations.
  4. Click **Add Amazon SQS**.
     <tip>
     If you’re installing an integration for the first time, you may be prompted to install Elastic Agent. If you see this page, click **Add integration only (skip agent installation)**.
     </tip>
  5. Configure the integration name and optionally add a description. Make sure you configure all required settings.
  6. Choose where to add the integration policy.
     - If Elastic Agent is not already deployed locally or on an EC2 instance, click **New hosts** and enter a name for the new agent policy.
  - Otherwise, click **Existing hosts** and select an existing agent policy.
  7. Click **Save and continue**. This step takes a minute or two to complete. When it’s done, you’ll have an agent policy that contains an integration policy for the configuration you just specified. If an Elastic Agent is already assigned to the policy, you’re done. Otherwise, you need to deploy an Elastic Agent.
  8. To deploy an Elastic Agent:
     1. In the popup, click **Add Elastic Agent to your hosts** to open the **Add agent** flyout. If you accidentally close the popup or the flyout doesn’t open, go to **Fleet → Agents**, then click **Add agent** to access the flyout.
  2. Follow the steps in the **Add agent** flyout to download, install, and enroll the Elastic Agent.
  9. When incoming data is confirmed—after a minute or two—click **View assets** to access the dashboards.
  For more information Elastic Agent and integrations, refer to the [Fleet and Elastic Agent documentation](https://www.elastic.co/docs/reference/fleet).
</dropdown>

Elastic Agent is currently the preferred way to add SQS metrics. For other ways, refer to [Adding data to Elasticsearch](https://www.elastic.co/docs/manage-data/ingest).

## Dashboards

For example, to see an overview of your SQS metrics in Kibana, go to the **Dashboard** app and navigate to the **[Metrics AWS] SQS Overview** dashboard.
![Screenshot showing the SQS overview dashboard](https://www.elastic.co/docs/solutions/images/observability-sqs-dashboard.png)


## Metrics to watch

Here are the key metrics that you should watch, organized by category. For a full list of fields exported by the integration, refer to the [Amazon SQS integration](https://docs.elastic.co/en/integrations/aws/sqs) docs.
- messages
  - `aws.sqs.messages.delayed`
- `aws.sqs.messages.not_visible`
- `aws.sqs.messages.visible`
- `aws.sqs.messages.deleted`
- `aws.sqs.messages.received`
- `aws.sqs.messages.sent`
- `aws.sqs.oldest_message_age.sec`
- `aws.sqs.sent_message_size.bytes`
- queue
  - `aws.sqs.queue.name`