﻿---
title: Ingestion options
description: You have a number of options for ingesting data with AWS. The following table helps you identify which option best fits your needs: The high-level architecture...
url: https://www.elastic.co/docs/solutions/observability/cloud/ingestion-options
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Ingestion options
You have a number of options for ingesting data with AWS. The following table helps you identify which option best fits your needs:

|                               | Amazon Data Firehose                                              | ESF                                                               | Elastic Agent                                                     | Beats                                                             |
|-------------------------------|-------------------------------------------------------------------|-------------------------------------------------------------------|-------------------------------------------------------------------|-------------------------------------------------------------------|
| **logs**                      | ![Yes](https://doc-icons.s3.us-east-2.amazonaws.com/icon-yes.png) | ![Yes](https://doc-icons.s3.us-east-2.amazonaws.com/icon-yes.png) | ![Yes](https://doc-icons.s3.us-east-2.amazonaws.com/icon-yes.png) | ![Yes](https://doc-icons.s3.us-east-2.amazonaws.com/icon-yes.png) |
| **metrics**                   | ![Yes](https://doc-icons.s3.us-east-2.amazonaws.com/icon-yes.png) | ![No](https://doc-icons.s3.us-east-2.amazonaws.com/icon-no.png)   | ![Yes](https://doc-icons.s3.us-east-2.amazonaws.com/icon-yes.png) | ![Yes](https://doc-icons.s3.us-east-2.amazonaws.com/icon-yes.png) |
| **PrivateLink support / VPC** | ![No](https://doc-icons.s3.us-east-2.amazonaws.com/icon-no.png)   | ![Yes](https://doc-icons.s3.us-east-2.amazonaws.com/icon-yes.png) | ![Yes](https://doc-icons.s3.us-east-2.amazonaws.com/icon-yes.png) | ![Yes](https://doc-icons.s3.us-east-2.amazonaws.com/icon-yes.png) |
| **pros**                      | Managed service, auto-scale                                       | Auto-scale, built-in support for SQS                              | Supports all integrations, manages multiple agents using Fleet    | Large configuration options                                       |
| **cons**                      | Few configuration options                                         | Partial integrations support                                      | Not a managed service, no auto-scale                              | Not a managed service, no auto-scale                              |


## Overview of the ingest process

The high-level architecture is shown below.
![Ingest options](https://www.elastic.co/docs/solutions/images/observability-ingest-options-overview.png)