﻿---
title: Application and service monitoring
description: Explore the topics in this section to learn how to observe and monitor software applications and services running in your environment. 
url: https://www.elastic.co/docs/solutions/observability/applications
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Application and service monitoring
Explore the topics in this section to learn how to observe and monitor software applications and services running in your environment.

|                                                                                                          |                                                                                                                                                                                                                      |
|----------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [LLM Observability](https://www.elastic.co/docs/solutions/observability/applications/llm-observability)  | Monitor LLM-powered applications to keep them reliable, efficient, cost-effective, and easy to troubleshoot.                                                                                                         |
| [Application performance monitoring (APM)](https://www.elastic.co/docs/solutions/observability/apm)      | Monitor software services and applications in real time, by collecting detailed performance information on response time for incoming requests, database queries, calls to caches, external HTTP requests, and more. |
| [Synthetic monitoring](https://www.elastic.co/docs/solutions/observability/synthetics)                   | Monitor the availability of network endpoints and services.                                                                                                                                                          |
| [Real user monitoring](https://www.elastic.co/docs/solutions/observability/applications/user-experience) | Quantify and analyze the perceived performance of your web application using real-world user experiences.                                                                                                            |
| [Uptime monitoring (deprecated)](https://www.elastic.co/docs/solutions/observability/uptime)             | Periodically check the status of your services and applications.                                                                                                                                                     |