﻿---
title: View the Elasticsearch index template
description: Index templates are used to configure the backing indices of data streams as they are created. These index templates are composed of multiple component...
url: https://www.elastic.co/docs/solutions/observability/apm/view-elasticsearch-index-template
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# View the Elasticsearch index template
Index templates are used to configure the backing indices of data streams as they are created. These index templates are composed of multiple component templates—reusable building blocks that configure index mappings, settings, and aliases.
The default APM index templates can be viewed in Kibana. To open **Index Management**, find it in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Select **Index Templates** and search for `apm`. Select any of the APM index templates to view their relevant component templates.

## Edit the Elasticsearch index template

<warning>
  Custom index mappings may conflict with the mappings defined by the Elasticsearch apm-data plugin and may break the APM integration and Applications UI in Kibana. Do not change or customize any default mappings.
</warning>

The APM index templates by default reference a non-existent `@custom` component template for each data stream. You can create or edit this `@custom` component template to customize your Elasticsearch indices.
First, determine which [data stream](https://www.elastic.co/docs/solutions/observability/apm/data-streams) you’d like to edit in Kibana. To open **Index Management**, find it in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Select **Component Templates**.
Custom component templates are named following this pattern: `<name_of_data_stream>@custom`. Search for the name of the data stream, like `traces-apm`, and select its custom component template. Create one if it does not exist. In this example, that’d be, `traces-apm@custom`. Then click **Manage** → **Edit**.
Add any custom metadata, index settings, or mappings.

### Index settings

In the **Index settings** step, you can specify custom [index settings](https://www.elastic.co/docs/reference/elasticsearch/index-settings). For example, you could:
- Customize the index lifecycle policy applied to a data stream. See [custom index lifecycle policies](/docs/solutions/observability/apm/index-lifecycle-management#apm-data-streams-custom-policy) for a walk-through.
- Change the number of [shards](https://www.elastic.co/docs/deploy-manage) per index. Specify the number of primary shards:
  ```json
  {
    "settings": {
      "number_of_shards": "4"
    }
  }
  ```
- Change the number of [replicas](https://www.elastic.co/docs/deploy-manage/distributed-architecture/reading-and-writing-documents) per index. Specify the number of replica shards:
  ```json
  {
    "index": {
      "number_of_replicas": "2"
    }
  }
  ```


### Mappings

[Mapping](https://www.elastic.co/docs/manage-data/data-store/mapping) is the process of defining how a document, and the fields it contains, are stored and indexed. In the **Mappings** step, you can add custom field mappings. For example, you could:
- Add custom field mappings that you can index on and search. In the **Mapped fields** tab, add a new field including the [field type](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/field-data-types):
  ![Editing a component template to add a new mapped field](https://www.elastic.co/docs/solutions/images/observability-custom-index-template-mapped-fields.png)
- Add a [runtime field](https://www.elastic.co/docs/manage-data/data-store/mapping/runtime-fields) that is evaluated at query time. In the **Runtime fields** tab, click **Create runtime field** and provide a field name, type, and optionally a script:
  ![Editing a component template to add a new runtime field](https://www.elastic.co/docs/solutions/images/observability-custom-index-template-runtime-fields.png)


## Roll over the data stream

Changes to component templates are not applied retroactively to existing indices. For changes to take effect, you must create a new write index for the data stream. This can be done with the Elasticsearch [Rollover API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-rollover). For example, to roll over the `traces-apm-default` data stream, run:
```json
```