﻿---
title: Use APM securely
description: When setting up Elastic APM, it’s critical to ensure that application data is secure from start to finish. You should approach securing your application...
url: https://www.elastic.co/docs/solutions/observability/apm/use-apm-securely
products:
  - APM
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Use APM securely
<admonition title="APM Server vs managed intake service">
  In Elastic Cloud Hosted, the _APM Server_ receives data from Elastic APM agents and transforms it into Elasticsearch documents. In Elastic Cloud Serverless there is in fact no APM Server running, instead the _managed intake service_ receives and transforms data.
</admonition>

When setting up Elastic APM, it’s critical to ensure that application data is secure from start to finish. You should approach securing your application data from different perspectives:

|                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
|----------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **What kind of data is collected?**                      | Ensure that data doesn’t contain sensitive information like passwords,  credit card numbers, health data, or other identifiable information.  Read more in [Secure data](https://www.elastic.co/docs/solutions/observability/apm/secure-data).                                                                                                                                                                                                            |
| **How do APM agents and Elastic Agent communicate?**     | Ensure that any communication between APM agents and Elastic Agent  are both encrypted and authenticated.  Read more in [Secure communication with APM agents](https://www.elastic.co/docs/solutions/observability/apm/secure-communication-with-apm-agents).                                                                                                                                                                                             |
| **How do APM Server and the Elastic Stack communicate?** | Use role-based access control to grant APM Server users access to secured resources. The roles that you set up depend on your organization’s security requirements and the  minimum privileges required to use specific features.  Read more in [Secure communication with the Elastic Stack](https://www.elastic.co/docs/solutions/observability/apm/secure-communication-with-elastic-stack).                                                           |
| **Is FIPS compatibility available for APM Server?**      | <applies-to>Elastic Stack: Preview since 9.1</applies-to>Yes! FIPS compatible binaries are available for download. Look for the `Linux x86_64 (FIPS)` or `Linux aarch64 (FIPS)` platform option on the [APM Server download](https://www.elastic.co/downloads/apm) page. Get more details about FIPS compatibility for APM Server and other ingest tools in [FIPS mode for Ingest tools](https://www.elastic.co/docs/deploy-manage/security/fips-ingest). |
| **Who can use the Applications UI?**                     | Use role-based access control to grant users access to features of the Applications UI.  Read more in [Secure access to the Applications UI](https://www.elastic.co/docs/solutions/observability/apm/secure-access-to-applications-ui).                                                                                                                                                                                                                   |