﻿---
title: Upgrade to version 9.0
description: This guide explains the upgrade process for version 9.0. For a detailed look at what’s new, check out: Elastic Observability release notes, What’s new...
url: https://www.elastic.co/docs/solutions/observability/apm/upgrade-to-version-9
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Upgrade to version 9.0
This guide explains the upgrade process for version 9.0. For a detailed look at what’s new, check out:
- [Elastic Observability release notes](https://www.elastic.co/docs/release-notes/observability)
- [What’s new in Kibana](https://www.elastic.co/docs/release-notes/kibana)
- [Elasticsearch release highlights](https://www.elastic.co/docs/release-notes/elasticsearch)


## Notable APM changes

- All index management has been removed from APM Server; the built-in Elasticsearch apm-data plugin is entirely responsible for setting up index templates, index lifecycle polices, and index pipelines.
- APM Server now only writes to well-defined data streams; writing to classic indices is no longer supported.
- APM Server has a new Elasticsearch output implementation with defaults that should be sufficient for most use cases.

As a result of the above changes, a number of index management and index tuning configuration variables have been removed. See the APM [release notes](https://www.elastic.co/docs/release-notes/apm), [breaking changes](https://www.elastic.co/docs/release-notes/apm/breaking-changes) for full details.

## Find your upgrade guide

Starting in version 7.14, there are two ways to run Elastic APM. Determine which method you’re using, then use the links below to find the correct upgrading guide.
- **Standalone**: Users in this mode run and configure the APM Server binary.
- **Fleet and the APM integration**: Users in this mode run and configure Fleet and the Elastic APM integration.

**Self-installation (non-Elastic Cloud users) upgrade guides**
- [Self-installation standalone](https://www.elastic.co/docs/solutions/observability/apm/upgrade-self-installation-of-apm-server-standalone-to-9)
- [Self-installation APM integration](https://www.elastic.co/docs/solutions/observability/apm/upgrade-self-installation-of-apm-integration-to-9)

**Elastic Cloud upgrade guides**
- [Elastic Cloud standalone](https://www.elastic.co/docs/solutions/observability/apm/upgrade-elastic-cloud-apm-server-standalone-to-9)
- [Elastic Cloud APM integration](https://www.elastic.co/docs/solutions/observability/apm/upgrade-elastic-cloud-with-apm-integration-to-9)