﻿---
title: Upgrade a self-installation of APM Server standalone to 9.0
description: This upgrade guide is for the standalone method of running APM Server. Only use this guide if both of the following are true: You have a self-installation...
url: https://www.elastic.co/docs/solutions/observability/apm/upgrade-self-installation-of-apm-server-standalone-to-9
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Upgrade a self-installation of APM Server standalone to 9.0
This upgrade guide is for the standalone method of running APM Server. Only use this guide if both of the following are true:
- You have a self-installation of the Elastic Stack, i.e. you’re not using Elastic Cloud.
- You’re running the APM Server binary, i.e. you haven’t switched to the Elastic APM integration.


## Prerequisites

1. Prior to upgrading to version 9.0, Elasticsearch, Kibana, and APM Server must be upgraded to version 8.18.
   - To upgrade Elasticsearch and Kibana, refer to the [Elastic Stack Installation and Upgrade Guide](https://www.elastic.co/guide/en/elastic-stack/8.18/upgrading-elastic-stack.html)
- To upgrade APM Server to version 8.18, refer to [upgrade to version 8.18](https://www.elastic.co/guide/en/observability/8.18/apm-upgrading-to-8.x.html).
2. Review the [Elastic APM release notes](https://www.elastic.co/docs/release-notes/apm) and [Elastic Observability release notes](https://www.elastic.co/docs/release-notes/observability).
3. Review the [Elastic APM breaking changes](https://www.elastic.co/docs/release-notes/apm/breaking-changes).


## Upgrade steps

1. **Upgrade the Elastic Stack to version 9.0**
   The Elastic Stack (Elasticsearch and Kibana) must be upgraded before APM Server. Refer to the [Elastic Stack Installation and Upgrade Guide](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster) for guidance.
2. **Install the 9.0 APM Server release**
   Refer to [install](/docs/solutions/observability/apm/apm-server/binary#apm-installing) to find the command that works with your system.
3. **Review your configuration file**
   Some settings have been removed or changed. You may need to update your `apm-server.yml` configuration file prior to starting the APM Server. Refer to [Installation layout](https://www.elastic.co/docs/solutions/observability/apm/apm-server/installation-layout) for help in locating this file, and [Configure APM Server](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure) for a list of all available configuration options.
4. **Start the APM Server**
   To start the APM Server, run:
   ```bash
   ./apm-server -e
   ```
   Additional details are available in [start the APM Server](/docs/solutions/observability/apm/apm-server/binary#apm-server-starting).
5. When upgrading from 8.18 to 9.0, if you have 7.x indices, you need to either set the indices to `readonly`, or if reindexing, add [ILM privileges](https://www.elastic.co/guide/en/apm/guide/7.17/privileges-to-setup-beats.html#_set_up_ilm) for `reindexed-v*-apm*` indices.
6. **(Optional) Upgrade to the APM integration**
   Got time for one more upgrade? Refer to [Switch to the Elastic APM integration](https://www.elastic.co/docs/solutions/observability/apm/switch-to-elastic-apm-integration).