﻿---
title: Upgrade a self-installation of the APM integration to 9.0
description: This upgrade guide is for the Elastic APM integration. Only use this guide if both of the following are true: You have a self-installation of the Elastic...
url: https://www.elastic.co/docs/solutions/observability/apm/upgrade-self-installation-of-apm-integration-to-9
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Upgrade a self-installation of the APM integration to 9.0
This upgrade guide is for the Elastic APM integration. Only use this guide if both of the following are true:
- You have a self-installation of the Elastic Stack, i.e. you’re not using Elastic Cloud.
- You have already switched to and are running Fleet and the Elastic APM integration.


## Prerequisites

1. Before you upgrade to version 9.0, you must upgrade Elasticsearch and Kibana to the latest patch version of 8.18. For more details, refer to the [Elastic Stack Installation and Upgrade Guide](https://www.elastic.co/guide/en/elastic-stack/8.18/upgrading-elastic-stack.html).
2. Review the [Elastic APM release notes](https://www.elastic.co/docs/release-notes/apm) and [Elastic Observability release notes](https://www.elastic.co/docs/release-notes/observability).
3. Review the [Elastic APM breaking changes](https://www.elastic.co/docs/release-notes/apm/breaking-changes).


## Upgrade steps

1. Upgrade the Elastic Stack to version 9.0.
   The Elastic Stack (Elasticsearch and Kibana) must be upgraded before Elastic Agent. refer to the [Elastic Stack Installation and Upgrade Guide](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster) for guidance.
2. Upgrade Elastic Agent to version 9.0 As a part of this process, the APM integration will automatically upgrade to version 9.0.
   1. In Fleet, select **Agents**.
2. Under **Agents**, click **Upgrade available** for a list of agents that you can upgrade.
3. Choose **Upgrade agent** from the **Actions** menu next to the agent you want to upgrade. The **Upgrade agent** option is grayed out when an upgrade is unavailable, or the Kibana version is lower than the agent version.
   For more details, or for bulk upgrade instructions, refer to [Upgrade Elastic Agent](https://www.elastic.co/docs/reference/fleet/upgrade-elastic-agent)
3. When upgrading from 8.18 to 9.0, if you have 7.x indices, you need to either set the indices to `readonly`, or if reindexing, add [ILM privileges](https://www.elastic.co/guide/en/apm/guide/7.17/privileges-to-setup-beats.html#_set_up_ilm) for `reindexed-v*-apm*` indices.