﻿---
title: Applications UI storage explorer user
description: View the Storage Explorer in the Applications UI. Create a new role, named something like storage-explorer_user, and assign the following privileges:,...
url: https://www.elastic.co/docs/solutions/observability/apm/ui-user-storage-explorer
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Applications UI storage explorer user
## Storage Explorer user

View the **Storage Explorer** in the Applications UI.
1. Create a new role, named something like `storage-explorer_user`, and assign the following privileges:
   <tab-set>
   <tab-item title="Data streams">
   | Type    | Privilege                   | Purpose                                               |
   |---------|-----------------------------|-------------------------------------------------------|
   | Cluster | `monitor`                   | Monitor the disk space used by APM data streams       |
   | Index   | `monitor` on `logs-apm*`    | Monitor access to `logs-apm*` for storage explorer    |
   | Index   | `monitor` on `metrics-apm*` | Monitor access to `metrics-apm*` for storage explorer |
   | Index   | `monitor` on `traces-apm*`  | Monitor access to `traces-apm*` for storage explorer  |
   </tab-item>

   <tab-item title="Classic APM indices">
   | Type    | Privilege            | Purpose                                        |
   |---------|----------------------|------------------------------------------------|
   | Cluster | `monitor`            | Monitor the disk space used by APM indices     |
   | Index   | `monitor` on `apm-*` | Monitor access to `apm-*` for storage explorer |
   </tab-item>
   </tab-set>
2. Assign the `storage-explorer_user` created previously, and the roles and privileges necessary to create a [full](/docs/solutions/observability/apm/ui-user-reader#apm-app-reader-full) or [partial](/docs/solutions/observability/apm/ui-user-reader#apm-app-reader-partial) APM reader to any users that need to view **Storage Explorer** in the Applications UI.