﻿---
title: Applications UI central config user
description: Central configuration users need to be able to view, create, update, and delete APM agent configurations. Create a new role, named something like central-config-manager,...
url: https://www.elastic.co/docs/solutions/observability/apm/ui-user-central-config
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Applications UI central config user
## Central configuration manager

Central configuration users need to be able to view, create, update, and delete APM agent configurations.
1. Create a new role, named something like `central-config-manager`, and assign the following privileges:
   <tab-set>
   <tab-item title="Data streams">
   | Type  | Privilege                                          | Purpose                                                      |
   |-------|----------------------------------------------------|--------------------------------------------------------------|
   | Index | `read` on `apm-agent-configuration`                | Read-only access to `apm-agent-configuration` data           |
   | Index | `view_index_metadata` on `apm-agent-configuration` | Read-only access to `apm-agent-configuration` index metadata |
   | Index | `read` on `logs-apm*`                              | Read-only access to `logs-apm*` data                         |
   | Index | `view_index_metadata` on `logs-apm*`               | Read-only access to `logs-apm*` index metadata               |
   | Index | `read` on `metrics-apm*`                           | Read-only access to `metrics-apm*` data                      |
   | Index | `view_index_metadata` on `metrics-apm*`            | Read-only access to `metrics-apm*` index metadata            |
   | Index | `read` on `traces-apm*`                            | Read-only access to `traces-apm*` data                       |
   | Index | `view_index_metadata` on `traces-apm*`             | Read-only access to `traces-apm*` index metadata             |
   </tab-item>

   <tab-item title="Classic APM indices">
   | Type  | Privilege                        | Purpose                                    |
   |-------|----------------------------------|--------------------------------------------|
   | Index | `read` on `apm-*`                | Read-only access to `apm-*` data           |
   | Index | `view_index_metadata` on `apm-*` | Read-only access to `apm-*` index metadata |
   </tab-item>
   </tab-set>
   <tip>
   Using the deprecated APM Server binaries? Add the privileges under the **Classic APM indices** tab above.
   </tip>
2. Assign the `central-config-manager` role created in the previous step, and the following Kibana feature privileges to anyone who needs to manage central configurations:
   | Type   | Privilege                                    | Purpose                                                    |
   |--------|----------------------------------------------|------------------------------------------------------------|
   | Kibana | `All` on the APM and User Experience feature | Allow full use of the Applications and User Experience UIs |


## Central configuration reader

In some instances, you may wish to create a user that can only read central configurations, but not create, update, or delete them.
1. Create a new role, named something like `central-config-reader`, and assign the following privileges:
   <tab-set>
   <tab-item title="Data streams">
   | Type  | Privilege                                          | Purpose                                                      |
   |-------|----------------------------------------------------|--------------------------------------------------------------|
   | Index | `read` on `apm-agent-configuration`                | Read-only access to `apm-agent-configuration` data           |
   | Index | `view_index_metadata` on `apm-agent-configuration` | Read-only access to `apm-agent-configuration` index metadata |
   | Index | `read` on `logs-apm*`                              | Read-only access to `logs-apm*` data                         |
   | Index | `view_index_metadata` on `logs-apm*`               | Read-only access to `logs-apm*` index metadata               |
   | Index | `read` on `metrics-apm*`                           | Read-only access to `metrics-apm*` data                      |
   | Index | `view_index_metadata` on `metrics-apm*`            | Read-only access to `metrics-apm*` index metadata            |
   | Index | `read` on `traces-apm*`                            | Read-only access to `traces-apm*` data                       |
   | Index | `view_index_metadata` on `traces-apm*`             | Read-only access to `traces-apm*` index metadata             |
   </tab-item>

   <tab-item title="Classic APM indices">
   | Type  | Privilege                        | Purpose                                    |
   |-------|----------------------------------|--------------------------------------------|
   | Index | `read` on `apm-*`                | Read-only access to `apm-*` data           |
   | Index | `view_index_metadata` on `apm-*` | Read-only access to `apm-*` index metadata |
   </tab-item>
   </tab-set>
   <tip>
   Using the deprecated APM Server binaries? Add the privileges under the **Classic APM indices** tab above.
   </tip>
2. Assign the `central-config-reader` role created in the previous step, and the following Kibana feature privileges to anyone who needs to read central configurations:
   | Type   | Privilege                                     | Purpose                                                       |
   |--------|-----------------------------------------------|---------------------------------------------------------------|
   | Kibana | `read` on the APM and User Experience feature | Allow read access to the Applications and User Experience UIs |


## Central configuration API

See [Create an API user](https://www.elastic.co/docs/solutions/observability/apm/ui-user-api).