﻿---
title: Applications UI API user
description: Users can list, search, create, update, and delete central configurations via the Applications UI API. Assign the following Kibana feature privileges:...
url: https://www.elastic.co/docs/solutions/observability/apm/ui-user-api
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Applications UI API user
## Central configuration API

Users can list, search, create, update, and delete central configurations via the Applications UI API.
1. Assign the following Kibana feature privileges:
   | Type   | Privilege                                    | Purpose                                                      |
   |--------|----------------------------------------------|--------------------------------------------------------------|
   | Kibana | `all` on the APM and User Experience feature | Allow all access to the Applications and User Experience UIs |


## Central configuration API reader

Sometimes a user only needs to list and search central configurations via the Applications UI API.
1. Assign the following Kibana feature privileges:
   | Type   | Privilege                                     | Purpose                                                       |
   |--------|-----------------------------------------------|---------------------------------------------------------------|
   | Kibana | `read` on the APM and User Experience feature | Allow read access to the Applications and User Experience UIs |


## Annotation API

Users can use the annotation API to create annotations on their APM data.
1. Create a new role, named something like `annotation_role`, and assign the following privileges:
   | Type  | Privilege                                           | Purpose                                                         |
   |-------|-----------------------------------------------------|-----------------------------------------------------------------|
   | Index | `manage` on `observability-annotations` index       | Check if the `observability-annotations` index exists           |
   | Index | `read` on `observability-annotations` index         | Read the `observability-annotations` index                      |
   | Index | `create_index` on `observability-annotations` index | Create the `observability-annotations` index                    |
   | Index | `create_doc` on `observability-annotations` index   | Create new annotations in the `observability-annotations` index |
2. Assign the `annotation_role` created previously, and the following Kibana feature privileges to any annotation API users:
   | Type   | Privilege                                    | Purpose                                                      |
   |--------|----------------------------------------------|--------------------------------------------------------------|
   | Kibana | `all` on the APM and User Experience feature | Allow all access to the Applications and User Experience UIs |