﻿---
title: Applications UI annotation user
description: View deployment annotations in the Applications UI. Create a new role, named something like annotation_user, and assign the following privileges:, 1 {{ANNOTATION_INDEX}}...
url: https://www.elastic.co/docs/solutions/observability/apm/ui-user-annotation
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Applications UI annotation user
<note>
  By default, the `viewer` and `editor` built-in roles provide read access to Observability annotations. You only need to create an annotation user to write to the annotations index ([`xpack.observability.annotations.index`](https://www.elastic.co/docs/reference/kibana/configuration-reference/apm-settings)).
</note>


## Annotation user

View deployment annotations in the Applications UI.
1. Create a new role, named something like `annotation_user`, and assign the following privileges:
   | Type  | Privilege                                        | Purpose                                                     |
   |-------|--------------------------------------------------|-------------------------------------------------------------|
   | Index | `read` on `{{ANNOTATION_INDEX}}`1                | Read-only access to the observability annotation index      |
   | Index | `view_index_metadata` on `{{ANNOTATION_INDEX}}`1 | Read-only access to observability annotation index metadata |
   1 `{{ANNOTATION_INDEX}}` should be the index name you’ve defined in [`xpack.observability.annotations.index`](https://www.elastic.co/docs/reference/kibana/configuration-reference/apm-settings).
2. Assign the `annotation_user` created previously, and the roles and privileges necessary to create a [full](/docs/solutions/observability/apm/ui-user-reader#apm-app-reader-full) or [partial](/docs/solutions/observability/apm/ui-user-reader#apm-app-reader-partial) APM reader to any users that need to view annotations in the Applications UI


## Annotation API

See [Create an API user](https://www.elastic.co/docs/solutions/observability/apm/ui-user-api).