﻿---
title: Traces UI in Elastic APM
description: Traces displays your application’s entry (root) transactions. Transactions with the same name are grouped together and only shown once in this table...
url: https://www.elastic.co/docs/solutions/observability/apm/traces-ui
products:
  - APM
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Traces UI in Elastic APM
<tip>
  Traces link together related transactions to show an end-to-end performance of how a request was served and which services were part of it. In addition to the Traces overview, you can view your application traces in the [trace sample timeline waterfall](https://www.elastic.co/docs/solutions/observability/apm/trace-sample-timeline).
</tip>

**Traces** displays your application’s entry (root) transactions. Transactions with the same name are grouped together and only shown once in this table. If you’re using [distributed tracing](/docs/solutions/observability/apm/trace-sample-timeline#distributed-tracing), this view is key to finding the critical paths within your application.
By default, transactions are sorted by *Impact*. Impact helps show the most used and slowest endpoints in your service — in other words, it’s the collective amount of pain a specific endpoint is causing your users. If there’s a particular endpoint you’re worried about, select it to view its [transaction details](/docs/solutions/observability/apm/transactions-ui#transaction-details).
You can also use queries to filter and search the transactions shown on this page. Note that only properties available on root transactions are searchable. For example, you can’t search for `label.tier: 'high'`, as that field is only available on non-root transactions.
![Example view of the Traces overview in Applications UI in Kibana](https://www.elastic.co/docs/solutions/images/observability-apm-traces.png)


## Trace explorer

<warning>
  This functionality is in technical preview and may be changed or removed in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.
</warning>

**Trace explorer** is an experimental top-level search tool that allows you to query your traces using [Kibana Query Language (KQL)](https://www.elastic.co/docs/explore-analyze/query-filter/languages/kql) or [Event Query Language (EQL)](https://www.elastic.co/docs/explore-analyze/query-filter/languages/eql).
Curate your own custom queries, or use the [**Service Map**](https://www.elastic.co/docs/solutions/observability/apm/service-map) to find and select edges to automatically generate queries based on your selection:
![Trace explorer](https://www.elastic.co/docs/solutions/images/observability-trace-explorer.png)