﻿---
title: Switch to the Elastic APM integration
description: The APM integration offers a number of benefits over the standalone method of running APM Server: Fleet: A single, unified way to add monitoring for logs,...
url: https://www.elastic.co/docs/solutions/observability/apm/switch-to-elastic-apm-integration
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Switch to the Elastic APM integration
The APM integration offers a number of benefits over the standalone method of running APM Server:
**Fleet**:
- A single, unified way to add monitoring for logs, metrics, traces, and other types of data to each host — install one thing instead of multiple
- Central, unified configuration management — no need to edit multiple configuration files

**Data streams**:
- Reduced number of fields per index, better space efficiency, and faster queries
- More granular data control
- Errors and metrics data streams are shared with other data sources — which means better long-term integration with the logs and metrics apps
- Removes template inheritance for ILM policies and makes use of new Elasticsearch index and component templates
- Fixes _resource 'apm-9.3.0-$type' exists, but it is not an alias_ error

**APM Integration**:
- Easier to install APM on edge machines
- Improved source map handling and APM agent configuration management
- Less configuration
- Easier and less error-prone upgrade path
- Zero-downtime configuration changes


## APM integration architecture

Elastic APM consists of four components: **APM agents**, the **Elastic APM integration**, **Elasticsearch**, and **Kibana**. Generally, there are two ways that these four components can work together:
APM agents on edge machines send data to a centrally hosted APM integration:
![centrally hosted APM integration](https://www.elastic.co/docs/solutions/images/apm-central-integrations.svg)
Or, APM agents and the APM integration live on edge machines and enroll via a centrally hosted Elastic Agent:
![APM edge machines](https://www.elastic.co/docs/solutions/images/apm-edge-integrations.svg)
<note>
  In order to collect data from RUM and mobile agents, which run in browser and mobile applications, you must run Elastic Agent centrally. For other applications, such as backend services, Elastic Agent may be co-located on the edge machine.
</note>


## Limitations

There are some limitations to be aware of:
- This change cannot be reverted
- Currently, only the Elasticsearch output is supported
- APM runs under Elastic Agent which, depending on the installation method, might require root privileges
- An Elastic Agent with the APM integration enabled must be managed by Fleet.


## Make the switch

Select a guide below to get started.
- [Switch a self-installation](https://www.elastic.co/docs/solutions/observability/apm/switch-self-installation-to-apm-integration)
- [Switch an Elastic Cloud cluster](https://www.elastic.co/docs/solutions/observability/apm/switch-an-elastic-cloud-cluster-to-apm-integration)