﻿---
title: Switch a self-installation to the APM integration
description: Upgrade the Elastic Stack, Add a Fleet Server, Install a Fleet-managed Elastic Agent, Add the APM integration, Stop the APM Server. The Elastic Stack...
url: https://www.elastic.co/docs/solutions/observability/apm/switch-self-installation-to-apm-integration
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Switch a self-installation to the APM integration
1. [Upgrade the Elastic Stack](#apm-integration-upgrade-1)
2. [Add a Fleet Server](#apm-integration-upgrade-2)
3. [Install a Fleet-managed Elastic Agent](#apm-integration-upgrade-3)
4. [Add the APM integration](#apm-integration-upgrade-4)
5. [Stop the APM Server](#apm-integration-upgrade-5)


## Upgrade the Elastic Stack

The Elastic Stack (Elasticsearch and Kibana) must be upgraded to version 7.14 or higher. See the [Elastic Stack Installation and Upgrade Guide](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster) for guidance.
Review the [Elastic APM release notes](https://www.elastic.co/docs/release-notes/apm) and [Elastic Observability release notes](https://www.elastic.co/docs/release-notes/observability) for important changes between your current APM version and this one.

## Add a Fleet Server

Fleet Server is a component of the Elastic Stack used to centrally manage Elastic Agents. The APM integration requires a Fleet Server to be running and accessible to your hosts. Add a Fleet Server by following [this guide](https://www.elastic.co/docs/reference/fleet/deployment-models).
<tip>
  If you’re upgrading a self-managed deployment of the Elastic Stack, you’ll need to enable [Elasticsearch security](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch) and the [API key service](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings).
</tip>

After adding your Fleet Server host and generating a service token, the in-product help in Kibana will provide a command to run to start an Elastic Agent as a Fleet Server. Commands may require administrator privileges.
Verify Fleet Server is running by navigating to **Fleet** > **Agents** in Kibana.

## Install a Fleet-managed Elastic Agent

<note>
  It’s possible to install the Elastic APM integration on the same Elastic Agent that is running the Fleet Server integration. For this use case, skip this step.
</note>

The Fleet-managed Elastic Agent will run the Elastic APM integration on your edge nodes, next to your applications. To install a Fleet-managed Elastic Agent, follow [this guide](https://www.elastic.co/docs/reference/fleet/install-fleet-managed-elastic-agent).

## Add the APM integration

The APM integration receives performance data from your APM agents, validates and processes it, and then transforms the data into Elasticsearch documents.
To add the APM integration, see [Step 2: Add and configure the APM integration](/docs/solutions/observability/apm/apm-server/fleet-managed#add-apm-integration). Only complete the linked step (not the entire quick start guide). If you’re adding the APM integration to a Fleet-managed Elastic Agent, you can use the default policy. If you’re adding the APM integration to the Fleet Server, use the policy that the Fleet Server is running on.
<tip>
  You’ll configure the APM integration in this step. See [Configure APM Server](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure) for a reference of all available settings. As long as the APM integration is configured with the same secret token or you have API keys enabled on the same host, no reconfiguration is required in your APM agents.
</tip>


## Stop the APM Server

Once data from upgraded APM agents is visible in the Applications UI, it’s safe to stop the APM Server process.
Congratulations — you now have the latest and greatest in Elastic APM!