﻿---
title: Switch an Elastic Cloud cluster to the APM integration
description: Upgrade the Elastic Stack, Switch to Elastic Agent, Configure the APM integration, Scale APM and Fleet. Use the Elastic Cloud Console to upgrade the Elastic...
url: https://www.elastic.co/docs/solutions/observability/apm/switch-an-elastic-cloud-cluster-to-apm-integration
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Switch an Elastic Cloud cluster to the APM integration
1. [Upgrade the Elastic Stack](#apm-integration-upgrade-ess-1)
2. [Switch to Elastic Agent](#apm-integration-upgrade-ess-2)
3. [Configure the APM integration](#apm-integration-upgrade-ess-3)
4. [Scale APM and Fleet](#apm-integration-upgrade-ess-4)


## Upgrade the Elastic Stack

Use the Elastic Cloud Console to upgrade the Elastic Stack to version 9.3.0. See the [Upgrade guide](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster) for details.

## Switch to Elastic Agent

APM data collection will be interrupted while the migration is in progress. The migration process should take only a few minutes.
With a Superuser account, complete these steps:
1. In the main menu, go to **Applications -> Service Inventory** or find `Service Inventory` using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), and then select **Settings → Schema**.
   ![switch to Elastic Agent](https://www.elastic.co/docs/solutions/images/observability-schema-agent.png)
2. Click **Switch to Elastic Agent**. Make a note of the `apm-server.yml` user settings that are incompatible with Elastic Agent. Check the confirmation box and click **Switch to Elastic Agent**.
   ![Elastic Agent settings migration](https://www.elastic.co/docs/solutions/images/observability-agent-settings-migration.png)

Elastic Cloud will now create a Fleet Server instance to contain the new APM integration, and then will shut down the old APM server instance. Within minutes your data should begin appearing in the Applications UI again.

## Configure the APM integration

You can now update settings that were removed during the upgrade. See [Configure APM Server](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure) for a reference of all available settings.
In Kibana, navigate to **Management** > **Fleet**. Select the **Elastic Cloud Agent Policy**. Next to the **Elastic APM** integration, select **Actions** > **Edit integration**.

## Scale APM and Fleet

Certain Elasticsearch output configuration options are not available with the APM integration. To ensure data is not lost, you can scale APM and Fleet up and out. APM’s capacity to process events increases with the instance memory size.
Go to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body), select your deployment and click **Edit**. Here you can edit the number and size of each availability zone.
![scale APM](https://www.elastic.co/docs/solutions/images/observability-scale-apm.png)

Congratulations — you now have the latest and greatest in Elastic APM!