﻿---
title: Services
description: The Services inventory provides a quick, high-level overview of the health and general performance of all instrumented services. To help surface potential...
url: https://www.elastic.co/docs/solutions/observability/apm/services
products:
  - APM
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Services
The **Services** inventory provides a quick, high-level overview of the health and general performance of all instrumented services.
To help surface potential issues, services are sorted by their health status: **critical** → **warning** → **healthy** → **unknown**. Health status is powered by [machine learning](https://www.elastic.co/docs/solutions/observability/apm/machine-learning) and requires anomaly detection to be enabled.
In addition to health status, active alerts for each service are prominently displayed in the service inventory table. Selecting an active alert badge brings you to the [**Alerts**](https://www.elastic.co/docs/solutions/observability/apm/create-apm-rules-alerts) tab where you can learn more about the active alert and take action.
![Example view of services table the Applications UI in Kibana](https://www.elastic.co/docs/solutions/images/observability-apm-services-overview.png)


## Service groups

<note>
  For Observability Serverless projects, the **Editor** role or higher is required to create and manage service groups. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles).
</note>

<important>
  The Service grouping functionality is in beta and is subject to change. The design and code is less mature than official generally available features and is being provided as-is with no warranties.
</important>

Group services together to build meaningful views that remove noise, simplify investigations across services, and combine related alerts.
![Example view of service group in the Applications UI in Kibana](https://www.elastic.co/docs/solutions/images/observability-apm-service-group.png)

To create a service group:
1. To open **Service inventory**, find **Applications** in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Switch to **Service groups**.
3. Click **Create group**.
4. Specify a name, color, and description.
5. Click **Select services**.
6. Specify a [Kibana Query Language (KQL)](https://www.elastic.co/docs/explore-analyze/query-filter/languages/kql) query to filter services by one or more of the following dimensions: `agent.name`, `service.name`, `service.language.name`, `service.environment`, `labels.<xyz>`. Services that match the query within the last 24 hours will be assigned to the group.


### Examples

Not sure where to get started? Here are some sample queries you can build from:
- **Group services by environment**: To group "production" services, use `service.environment : "production"`.
- **Group services by name**: To group all services that end in "beat", use `service.name : *beat`. This will match services named "Auditbeat", "Heartbeat", "Filebeat", and so on.