﻿---
title: Secure communication with the Elastic Stack
description: Use role-based access control or API keys to grant APM Server users access to secured resources. Manage access on a feature-by-feature basis by creating...
url: https://www.elastic.co/docs/solutions/observability/apm/secure-communication-with-elastic-stack
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Secure communication with the Elastic Stack
<note>
  This documentation only applies to the APM Server binary.
</note>

Use role-based access control or API keys to grant APM Server users access to secured resources.

## Role-based access

Manage access on a feature-by-feature basis by creating several custom feature-related roles and assigning one or more of these roles to each APM Server user based on which features they need to access.
[**Read more in Use feature roles →**](https://www.elastic.co/docs/solutions/observability/apm/create-assign-feature-roles-to-apm-server-users)

## API keys

Instead of using usernames and passwords, you can use API keys to grant access to Elasticsearch resources. You can set API keys to expire at a certain time, and you can explicitly invalidate them.
[**Read more in Grant access using API keys →**](https://www.elastic.co/docs/solutions/observability/apm/grant-access-using-api-keys)

## More resources

After privileged users have been created, use authentication to connect to a secured Elastic cluster.
- [Secure communication with Elasticsearch](/docs/solutions/observability/apm/apm-server/configure-elasticsearch-output#apm-securing-communication-elasticsearch)
- [Secure communication with Logstash](/docs/solutions/observability/apm/apm-server/configure-logstash-output#apm-configuring-ssl-logstash)

For secure communication between APM Server and APM Agents, see [Secure communication with APM agents](https://www.elastic.co/docs/solutions/observability/apm/secure-communication-with-apm-agents).
A reference of all available [SSL configuration settings](https://www.elastic.co/docs/solutions/observability/apm/apm-server/ssl-tls-settings) is also available.
<important>
  APM Server exposes an HTTP endpoint, and as with anything that opens ports on your servers, you should be careful about who can connect to it. Firewall rules are recommended to ensure only authorized systems can connect.
</important>