﻿---
title: Secure communication with APM agents
description: Communication between APM agents and Elastic Agent can be both encrypted and authenticated. It is strongly recommended to use both TLS encryption and...
url: https://www.elastic.co/docs/solutions/observability/apm/secure-communication-with-apm-agents
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Secure communication with APM agents
Communication between APM agents and Elastic Agent can be both encrypted and authenticated. It is strongly recommended to use both TLS encryption and authentication as secrets are sent as plain text.
- [TLS encryption](https://www.elastic.co/docs/solutions/observability/apm/apm-agent-tls-communication)
- [API key authentication](https://www.elastic.co/docs/solutions/observability/apm/api-keys)
- [Secret token authentication](https://www.elastic.co/docs/solutions/observability/apm/secret-token)

As soon as an authenticated communication is enabled, requests without a valid token or API key will be denied. If both API keys and a secret token are enabled, APM agents can choose whichever mechanism they support.
In some use-cases, like when an APM agent is running on the client side, authentication is not possible. See [Anonymous authentication](https://www.elastic.co/docs/solutions/observability/apm/anonymous-authentication) for more information.