﻿---
title: Secure access to the Applications UI
description: Use role-based access control to grant users access to secured resources. The roles that you set up depend on your organization’s security requirements...
url: https://www.elastic.co/docs/solutions/observability/apm/secure-access-to-applications-ui
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Secure access to the Applications UI
Use role-based access control to grant users access to secured resources. The roles that you set up depend on your organization’s security requirements and the minimum privileges required to use specific features.
Elasticsearch security features provides [built-in roles](https://www.elastic.co/docs/reference/elasticsearch/roles) that grant a subset of the privileges needed by APM users. When possible, assign users the built-in roles to minimize the affect of future changes on your security strategy. If no built-in role is available, you can assign users the privileges needed to accomplish a specific task. In general, there are three types of privileges you’ll work with:
- **Elasticsearch cluster privileges**: Manage the actions a user can perform against your cluster.
- **Elasticsearch index privileges**: Control access to the data in specific indices your cluster.
- **Kibana feature privileges**: Grant users write or read access to features and apps within Kibana.

Select your use-case to get started:
- [Create an APM reader user](https://www.elastic.co/docs/solutions/observability/apm/ui-user-reader)
- [Create an annotation user](https://www.elastic.co/docs/solutions/observability/apm/ui-user-annotation)
- [Create a central config user](https://www.elastic.co/docs/solutions/observability/apm/ui-user-central-config)
- [Create a storage explorer user](https://www.elastic.co/docs/solutions/observability/apm/ui-user-storage-explorer)
- [Create an API user](https://www.elastic.co/docs/solutions/observability/apm/ui-user-api)