﻿---
title: Secret token
description: When defined, secret tokens are used to authorize requests to the APM Server. Both the APM agent and APM Server must be configured with the same secret...
url: https://www.elastic.co/docs/solutions/observability/apm/secret-token
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Secret token
<important>
  Secret tokens are sent as plain-text, so they only provide security when used in combination with [TLS](https://www.elastic.co/docs/solutions/observability/apm/apm-agent-tls-communication).
</important>

When defined, secret tokens are used to authorize requests to the APM Server. Both the APM agent and APM Server must be configured with the same secret token for the request to be accepted.
To secure the communication between APM agents and the APM Server with a secret token:
1. Make sure [TLS](https://www.elastic.co/docs/solutions/observability/apm/apm-agent-tls-communication) is enabled
2. [Create a secret token](#apm-create-secret-token)
3. [Configure the secret token in your APM agents](#apm-configure-secret-token)

<note>
  Secret tokens are not applicable for the RUM Agent, as there is no way to prevent them from being publicly exposed.
</note>


## Create a secret token

<note>
  Elastic Cloud Hosted and Elastic Cloud Enterprise deployments provision a secret token when the deployment is created. The secret token can be found and reset in the Elastic Cloud Console under the deployment's **APM & Fleet** page.
</note>

<tab-set>
  <tab-item title="Fleet-managed">
    Create or update a secret token in Fleet.Configure and customize Fleet-managed APM settings directly in Kibana:
    1. In Kibana, find **Fleet** in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Under the **Agent policies** tab, select the policy you would like to configure.
    3. Find the Elastic APM integration and select **Actions** > **Edit integration**.
    4. Navigate to **Agent authorization** > **Secret token** and set the value of your token.
    5. Click **Save integration**. The APM Server will restart before the change takes effect.
  </tab-item>

  <tab-item title="APM Server binary">
    Set the secret token in `apm-server.yaml`:
    ```yaml
    apm-server.auth.secret_token: <secret-token>
    ```
  </tab-item>
</tab-set>


## Configure the secret token in your APM agents

Each Elastic APM agent has a configuration option to set the value of the secret token:
- **Android agent**: [`secretToken`](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/configuration)
- **Go agent**: [`ELASTIC_APM_SECRET_TOKEN`](https://www.elastic.co/docs/reference/apm/agents/go/configuration#config-secret-token)
- **iOS agent**: [`secretToken`](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios/configuration#secrettoken)
- **Java agent**: [`secret_token`](https://www.elastic.co/docs/reference/apm/agents/java/config-reporter#config-secret-token)
- **.NET agent**: [`ELASTIC_APM_SECRET_TOKEN`](https://www.elastic.co/docs/reference/apm/agents/dotnet/config-reporter#config-secret-token)
- **Node.js agent**: [`Secret Token`](https://www.elastic.co/docs/reference/apm/agents/nodejs/configuration#secret-token)
- **PHP agent**: [`secret_token`](https://www.elastic.co/docs/reference/apm/agents/php/configuration-reference#config-secret-token)
- **Python agent**: [`secret_token`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-secret-token)
- **Ruby agent**: [`secret_token`](https://www.elastic.co/docs/reference/apm/agents/ruby/configuration#config-secret-token)

In addition to setting the secret token, ensure the configured server URL uses `HTTPS` instead of `HTTP`:
- **Go agent**: [`ELASTIC_APM_SERVER_URL`](https://www.elastic.co/docs/reference/apm/agents/go/configuration#config-server-url)
- **Java agent**: [`server_urls`](https://www.elastic.co/docs/reference/apm/agents/java/config-reporter#config-server-urls)
- **.NET agent**: [`ServerUrl`](https://www.elastic.co/docs/reference/apm/agents/dotnet/config-reporter#config-server-url)
- **Node.js agent**: [`serverUrl`](https://www.elastic.co/docs/reference/apm/agents/nodejs/configuration#server-url)
- **PHP agent**: [`server_url`](https://www.elastic.co/docs/reference/apm/agents/php/configuration-reference#config-server-url)
- **Python agent**: [`server_url`](https://www.elastic.co/docs/reference/apm/agents/python)
- **Ruby agent**: [`server_url`](https://www.elastic.co/docs/reference/apm/agents/ruby/configuration#config-server-url)