﻿---
title: OpenTelemetry limitations in Elastic APM
description: Traces of applications using messaging semantics might be wrongly displayed as transactions in the Applications UI, while they should be considered spans...
url: https://www.elastic.co/docs/solutions/observability/apm/opentelemetry/limitations
products:
  - APM
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# OpenTelemetry limitations in Elastic APM
## OpenTelemetry traces

- Traces of applications using `messaging` semantics might be wrongly displayed as `transactions` in the Applications UI, while they should be considered `spans` (see issue [#7001](https://github.com/elastic/apm-server/issues/7001)).
- Inability to see Stack traces in spans.
- Inability in APM views to view the "Time Spent by Span Type"  (see issue [#5747](https://github.com/elastic/apm-server/issues/5747)).


## OpenTelemetry logs

- The OpenTelemetry logs intake through the [APM Server](/docs/solutions/observability/apm/opentelemetry/upstream-opentelemetry-collectors-language-sdks#apm-open-telemetry-proxy-apm) is in technical preview. <applies-to>: Preview</applies-to>
- The application logs data stream (`app_logs`) has dynamic mapping disabled. This means the automatic detection and mapping of new fields is disabled (see issue [#9093](https://github.com/elastic/apm-server/issues/9093)).

<note>
  Logs ingest through the [EDOT Collector](https://www.elastic.co/docs/reference/edot-collector) is fully supported.
</note>


## OpenTelemetry Line Protocol (OTLP)

Elastic supports both the  [OTLP/gRPC](https://opentelemetry.io/docs/specs/otlp/#otlpgrpc) and [OTLP/HTTP](https://opentelemetry.io/docs/specs/otlp/#otlphttp) protocol with ProtoBuf payload. Elastic does not yet support JSON Encoding for OTLP/HTTP.

## EDOT SDKs with APM Server OTel intake

EDOT SDKs are tested and supported only with [EDOT Collector Gateway](https://www.elastic.co/docs/reference/edot-collector/modes#edot-collector-as-gateway) or [Managed OTel intake](https://www.elastic.co/docs/reference/opentelemetry/motlp). Using EDOT SDKs directly with APM Server's OTel intake is not supported.

## OpenTelemetry Collector exporter for Elastic

The [OpenTelemetry Collector exporter for Elastic](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/v0.57.2/exporter/elasticexporter) has been deprecated and replaced by the native support of the OpenTelemetry Line Protocol in Elastic Observability (OTLP).
The [OpenTelemetry Collector exporter for Elastic](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/exporter/elasticsearchexporter) (which is different from the legacy exporter mentioned above) is not intended to be used with Elastic APM and Elastic Observability. Use [Elastic’s native OTLP support](https://www.elastic.co/docs/solutions/observability/apm/opentelemetry/upstream-opentelemetry-collectors-language-sdks) instead.

## OpenTelemetry’s tail-based sampling

<applies-to>
  - Elastic Stack: Generally available
</applies-to>

Tail-based sampling allows to make sampling decisions after all spans of a trace have been completed. This allows for more powerful and informed sampling rules.
When using OpenTelemetry with Elastic APM, there are two different implementations available for tail-based sampling:
- Tail-based sampling using the [tailsamplingprocessor](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/processor/tailsamplingprocessor) in the OpenTelemetry Collector
- Native [tail-based sampling in the Elastic APM backend](/docs/solutions/observability/apm/transaction-sampling#apm-tail-based-sampling)

Using the [tailsamplingprocessor](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/processor/tailsamplingprocessor) in the OpenTelemetry Collector comes with an important limitation when used with APM Server. Elastic’s APM backend calculates span and transaction metrics based on the incoming span events. These metrics are accurate for 100% sampling scenarios. In scenarios with probabilistic sampling, Elastic’s APM backend is being informed about the sampling rate of spans and can extrapolate throughput metrics based on the incoming, partial data. However, with tail-based sampling there’s no clear probability for sampling decisions as the rules can be more complex and the OpenTelemetry Collector does not provide sampling probability information to the Elastic backend that could be used for extrapolation of data. Therefore, there’s no way for APM Server to properly extrapolate throughput and count metrics that are derived from span events that have been tail-based sampled in the OpenTelemetry Collector. In these scenarios, derived throughput and count metrics are likely to be inaccurate.
Use the [EDOT Collector tail-based sampling](https://www.elastic.co/docs/reference/edot-collector/config/tail-based-sampling) instead of sending data directly to APM Server. The EDOT Collector provides native support for tail-based sampling that properly handles metric extrapolation.