﻿---
title: Central Configuration for EDOT SDKs
description: APM Agent Central Configuration allows you to fine-tune your EDOT SDKs from within the Applications UI. Changes are automatically propagated to your SDKs,...
url: https://www.elastic.co/docs/solutions/observability/apm/opentelemetry/edot-sdks-central-configuration
products:
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Preview since 9.1
---

# Central Configuration for EDOT SDKs
APM Agent Central Configuration allows you to fine-tune your EDOT SDKs from within the Applications UI. Changes are automatically propagated to your SDKs, so there’s no need to redeploy.
To get started, select the services and environments you want to configure. The Applications UI lets you know when your EDOT SDKs have applied your configurations.

## Precedence

Configurations set from the Applications UI take precedence over configurations set locally in each EDOT SDK. If the EDOT Collector is offline, reports an error, or is slow to respond, EDOT SDKs use local defaults until they’re able to update the configuration.

## Supported configurations

Each EDOT SDK has a list of supported configurations. After selecting a Service name and environment in the Applications UI, a list of all supported configuration options, including descriptions and default values, will be displayed.
Supported configurations are also tagged with the ![dynamic config](https://www.elastic.co/docs/solutions/images/observability-dynamic-config.svg) badge in each EDOT SDK’s configuration reference:

| Language/Platform | EDOT SDK         | Configuration Reference                                                                                        |
|-------------------|------------------|----------------------------------------------------------------------------------------------------------------|
| Android           | EDOT Android SDK | [Configuration reference](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/configuration) |
| iOS               | EDOT iOS SDK     | [Configuration reference](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios/configuration)     |
| Java              | EDOT Java SDK    | [Configuration reference](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java/configuration)    |
| Node.js           | EDOT Node.js SDK | [Configuration reference](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node/configuration)    |
| PHP               | EDOT PHP SDK     | [Configuration reference](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/php/configuration)     |
| Python            | EDOT Python SDK  | [Configuration reference](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/configuration)  |


## EDOT configuration

EDOT SDK configuration is an optional feature. To activate it, refer to [EDOT SDK Central Configuration](https://www.elastic.co/docs/solutions/observability/apm/opentelemetry/edot-sdks-central-configuration).
Refer to the [EDOT reference](https://www.elastic.co/docs/reference/opentelemetry/central-configuration) to learn how to activate central configuration for EDOT SDKs.
<note>
  You can't configure APM agents through the EDOT Collector. Use APM Server for that purpose. Refer to [Configure APM agent configuration](https://www.elastic.co/docs/solutions/observability/apm/apm-server/apm-agent-central-configuration) for more details.
</note>