﻿---
title: Data stream routing
description: Elastic APM supports routing APM data to user-defined data stream names using the reroute processor. However, you can also ingest OTLP data without having...
url: https://www.elastic.co/docs/solutions/observability/apm/opentelemetry/data-stream-routing
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Data stream routing
Elastic APM supports [routing APM data](/docs/solutions/observability/apm/data-streams#apm-data-stream-rerouting) to user-defined data stream names using the [`reroute` processor](https://www.elastic.co/docs/reference/enrich-processor/reroute-processor). However, you can also ingest OTLP data without having to create new ingest pipelines.

## Setting data stream attributes

To automatically route OTLP data, set the `data_stream.dataset` and `data_stream.namespace` attributes. These attributes map to the respective [ECS fields](https://www.elastic.co/docs/reference/ecs/ecs-data_stream).
You can set the `data_stream` attributes at resource level, scope level, and record level. Elastic parses the attributes in increasing order of precedence. For example, record `data_stream` attributes override the scope `data_stream` attributes. This implies that `data_stream` attributes are inherited from previous levels. If a scope does not specify `data_stream` attributes, it uses the resource attributes.
For guidance on how to set resource attributes in OpenTelemetry, refer to [setting resource attributes](/docs/solutions/observability/apm/opentelemetry/attributes#setting-resource-attributes).