﻿---
title: Create APM agent key for EDOT SDKs
description: Learn how to create an APM agent key for Elastic Distribution of OpenTelemetry (EDOT) SDKs using Kibana.
url: https://www.elastic.co/docs/solutions/observability/apm/opentelemetry/create-apm-agent-key-for-edot-sdks
products:
  - APM
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Create APM agent key for EDOT SDKs
APM agent keys are least-privilege API keys for ingesting APM data. Create these keys using the Applications UI in Kibana.
<important>
  APM agent keys are sent as plain text, so they only provide security when used in combination with [TLS](https://www.elastic.co/docs/solutions/observability/apm/apm-agent-tls-communication).
</important>


## Difference from Stack Management API keys

There are two ways to create API keys in Kibana:
- **Stack Management > API keys > Create API key**: Creates general-purpose API keys for Elasticsearch operations. For more information, refer to [Elasticsearch API keys](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys).
- **Applications > Settings > Agent keys > Create APM agent key** (the method described on this page): Creates API keys specifically for ingesting APM data. All [Elastic Distribution of OpenTelemetry (EDOT) SDKs](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks) should use this method.


## Create an APM agent key

The Applications UI provides a built-in workflow to create APM agent keys. These keys have the minimum required privileges for EDOT SDKs to send data to Elastic.
To create an APM agent key:
1. In Kibana, find **Applications** in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select any **Applications** page.
3. Go to **Settings** > **Agent keys**.
4. Select **Create APM agent key**.
5. Enter a name for your API key.
6. Assign at least one privilege:
   - **Agent configuration** (`config_agent:read`): Required to use agent central configuration for remote configuration.
- **Ingest** (`event:write`): Required to ingest agent events.
7. Select **Create APM agent key**.
8. Copy the API key now. The key is shown only once.

<note>
  API keys do not expire.
</note>

![APM agent key creation](https://www.elastic.co/docs/solutions/images/observability-apm-ui-api-key.png)

For EDOT SDKs, the **Agent configuration** privilege enables [EDOT SDKs Central Configuration](https://www.elastic.co/docs/reference/opentelemetry/central-configuration) for remote configuration.

## Use the APM agent key with EDOT SDKs

After creating the APM agent key, configure your EDOT SDK to use it. Configuration details vary by language and deployment:
- **Android**: [`apiKey`](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/configuration)
- **.NET**: [`ApiKey`](https://www.elastic.co/docs/reference/apm/agents/dotnet/config-reporter#config-api-key)
- **iOS**: [`withApiKey`](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios/configuration#withapikey)
- **Java**: [`api_key`](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java/configuration)
- **Node.js**: [`apiKey`](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node/configuration)
- **PHP**: [`api_key`](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/php/configuration)
- **Python**: [`api_key`](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/configuration)


## Required user privileges

To create an APM agent key, you must have the required privileges:
<tab-set>
  <tab-item title="Fleet-managed or APM Server binary">
    You must have the `manage_own_api_key` cluster privilege and the APM application privileges you plan to assign to the key. Additionally, appropriate Kibana Space and Feature privileges are needed to access the Applications UI.For details on configuring the minimum required privileges, refer to [API keys for Elastic APM](/docs/solutions/observability/apm/api-keys#apm-create-api-key-user).
  </tab-item>

  <tab-item title="Elastic Cloud Serverless">
    For Observability Serverless projects, the Editor role or higher is required to create and manage API keys. Refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles) for more information.
  </tab-item>
</tab-set>