﻿---
title: Use OpenTelemetry with Elastic APM
description: Learn how to integrate OpenTelemetry with Elastic APM using Elastic Distributions, contrib SDKs, and APM agents. Includes setup for serverless, self-managed, and AWS Lambda.
url: https://www.elastic.co/docs/solutions/observability/apm/opentelemetry
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Use OpenTelemetry with Elastic APM
OpenTelemetry is a set of APIs, SDKs, tooling, and integrations that enable the capture and management of telemetry data from your services and applications. You can use OpenTelemetry to collect application performance data in Elastic APM, whether you’re running serverless, self-managed, or hybrid deployments.
<important applies-to="Elastic Cloud Serverless: Generally available, Elastic Stack: Generally available since 9.2">
  **Install OpenTelemetry content packs to work with OpenTelemetry data**To visualize data from OpenTelemetry receivers which is stored natively as OpenTelemetry semantic conventions, you must install content-only packs that provide dashboards compatible with OpenTelemetry data.In the Kibana Integrations UI, search for `otel` to find and install available integrations, like **System OpenTelemetry Assets**, to access the dashboards. We are adding more OpenTelemetry content packs every week, reach out by [opening an issue](https://github.com/elastic/integrations/issues) if what you are looking for is not available as an OTel content pack.Other Integrations which are beats-based include dashboards based on ECS data and are not compatible with OpenTelemetry semantic conventions.
</important>

Elastic offers several distributions of OpenTelemetry. Each [Elastic Distribution of OpenTelemetry](https://www.elastic.co/docs/reference/opentelemetry) is a customized version of an OpenTelemetry language SDK and the OpenTelemetry Collector, ready to send data to the [Managed OTLP endpoint](https://www.elastic.co/docs/reference/opentelemetry/motlp), APM Server, or directly to Elasticsearch.
The following diagrams show the reference architecture for OpenTelemetry with Elastic, depending on your deployment model.
<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    ![APM data ingest path (Serverless)](https://www.elastic.co/docs/solutions/images/observability-apm-otel-distro-serverless.png)
  </applies-item>

  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    - <applies-to>Elastic Stack: Preview since 9.2</applies-to>
      ![](https://www.elastic.co/docs/solutions/images/ech-preview-motlp.png)

    - <applies-to>Elastic Stack: Generally available in 9.1</applies-to>
      ![](https://www.elastic.co/docs/solutions/images/observability-apm-otel-distro-ech.png)
  </applies-item>

  <applies-item title="self:" applies-to="Self-managed Elastic deployments: Generally available">
    ![APM data ingest path (Self-managed)](https://www.elastic.co/docs/solutions/images/observability-apm-otel-distro-self-managed.png)
  </applies-item>
</applies-switch>


## Why use the Elastic Distributions of OpenTelemetry?

With an [Elastic Distribution of OpenTelemetry language SDK](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks) you have access to all the features of the OpenTelemetry SDK that it customizes, plus:
- You can get access to SDK improvements and bug fixes contributed by the Elastic team before the changes are available in the OpenTelemetry repositories.
- The distribution configures the collection of tracing and metrics signals, applying opinionated defaults, such as which sources are collected by default.
- By sending data through the [EDOT Collector](https://www.elastic.co/docs/reference/edot-collector), you make sure to onboard infrastructure logs and metrics.

To set up OpenTelemetry with Elastic, refer to these guides for each language:
- [**Elastic Distribution of OpenTelemetry Java**](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java)
- [**Elastic Distribution of OpenTelemetry .NET**](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/dotnet)
- [**Elastic Distribution of OpenTelemetry Node.js**](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node)
- [**Elastic Distribution of OpenTelemetry Python**](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python)
- [**Elastic Distribution of OpenTelemetry PHP**](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/php)

<important>
  For a complete overview of OpenTelemetry and Elastic, explore [**Elastic Distributions of OpenTelemetry**](https://www.elastic.co/docs/reference/opentelemetry).
</important>


## Contrib OpenTelemetry Collector and SDKs

The Elastic Stack natively supports the OpenTelemetry protocol (OTLP). This means trace data and metrics collected from your applications and infrastructure by an OpenTelemetry Collector or OpenTelemetry language SDK can be sent to Elastic.
You can set up an OpenTelemetry Collector based on contrib OpenTelemetry, instrument your application with an OpenTelemetry language SDK that sends data to the Collector, and use the Collector to process and export the data to either the [Managed OTLP endpoint](https://www.elastic.co/docs/reference/opentelemetry/motlp) or APM Server or the managed intake service.
This approach works well when you need to instrument a technology that Elastic doesn’t provide a solution for. For example, if you want to instrument C or C++ you can use the [OpenTelemetry C++ client](https://github.com/open-telemetry/opentelemetry-cpp). However, there are some limitations when using contrib OpenTelemetry collectors and language SDKs, including:
- Elastic can’t provide implementation support on how to use contrib OpenTelemetry tools.
- You won’t have access to Elastic enterprise APM features.
- You might experience problems with performance efficiency.

For more on the limitations associated with using contrib OpenTelemetry tools, refer to [Limitations](https://www.elastic.co/docs/solutions/observability/apm/opentelemetry/limitations).
[**Get started with contrib OpenTelemetry Collectors and language SDKs →**](https://www.elastic.co/docs/solutions/observability/apm/opentelemetry/upstream-opentelemetry-collectors-language-sdks)
<note>
  To understand the differences between Elastic Distributions of OpenTelemetry and contrib OpenTelemetry, refer to [EDOT compared to contrib OpenTelemetry](https://www.elastic.co/docs/reference/opentelemetry/compatibility/edot-vs-upstream).
</note>


## Contrib OpenTelemetry with Elastic APM agent

You can use the OpenTelemetry API/SDKs with [Elastic APM agents](/docs/solutions/observability/apm/apm-server/fleet-managed#_step_3_install_apm_agents) to translate OpenTelemetry API calls to Elastic APM API calls. This allows you to reuse your existing OpenTelemetry instrumentation to create Elastic APM transactions and spans, avoiding vendor lock-in and having to redo manual instrumentation.
However, not all features of the OpenTelemetry API are supported when using this approach, and not all Elastic APM agents support this approach.
Find more details about how to use an OpenTelemetry API or SDK with an Elastic APM agent and which OpenTelemetry API features are supported in the APM agent documentation:
- [**APM Java agent**](https://www.elastic.co/docs/reference/apm/agents/java/opentelemetry-bridge)
- [**APM .NET agent**](https://www.elastic.co/docs/reference/apm/agents/dotnet/opentelemetry-bridge)
- [**APM Node.js agent**](https://www.elastic.co/docs/reference/apm/agents/nodejs/opentelemetry-bridge)
- [**APM Python agent**](https://www.elastic.co/docs/reference/apm/agents/python/opentelemetry-api-bridge)


## AWS Lambda Collector Exporter

AWS Lambda functions can be instrumented with OpenTelemetry and monitored with Elastic Observability or Elastic Observability Serverless.
To get started, follow the official AWS Distribution for OpenTelemetry Lambda documentation, and [configure the EDOT Collector in Gateway mode](https://www.elastic.co/docs/reference/edot-collector/config/default-config-standalone#gateway-mode) to send traces and metrics to your Elastic cluster:
[**Get started with the AWS Distro for OpenTelemetry Lambda**](https://aws-otel.github.io/docs/getting-started/lambda)