﻿---
title: OpenTelemetry intake API
description: APM Server supports receiving traces, metrics, and logs over the OpenTelemetry Protocol (OTLP). OTLP is the default transfer protocol for OpenTelemetry...
url: https://www.elastic.co/docs/solutions/observability/apm/opentelemetry-intake-api
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# OpenTelemetry intake API
APM Server supports receiving traces, metrics, and logs over the [OpenTelemetry Protocol (OTLP)](https://opentelemetry.io/docs/specs/otlp/). OTLP is the default transfer protocol for OpenTelemetry and is supported natively by APM Server.
APM Server supports two OTLP communication protocols on the same port:
- OTLP/HTTP (protobuf)
- OTLP/gRPC

<important>
  EDOT SDKs are tested and supported only with [EDOT Collector Gateway](https://www.elastic.co/docs/reference/edot-collector/modes#edot-collector-as-gateway) or [Managed OTel intake](https://www.elastic.co/docs/reference/opentelemetry/motlp). Using EDOT SDKs directly with APM Server's OTel intake is not supported.
</important>


## OTLP/gRPC paths


| Name                | Endpoint                                                          |
|---------------------|-------------------------------------------------------------------|
| OTLP metrics intake | `/opentelemetry.proto.collector.metrics.v1.MetricsService/Export` |
| OTLP trace intake   | `/opentelemetry.proto.collector.trace.v1.TraceService/Export`     |
| OTLP logs intake    | `/opentelemetry.proto.collector.logs.v1.LogsService/Export`       |


## OTLP/HTTP paths


| Name                | Endpoint      |
|---------------------|---------------|
| OTLP metrics intake | `/v1/metrics` |
| OTLP trace intake   | `/v1/traces`  |
| OTLP logs intake    | `/v1/logs`    |

<tip>
  See our OpenTelemetry documentation to learn how to send data to the APM Server from an [OpenTelemetry agent](/docs/solutions/observability/apm/opentelemetry/upstream-opentelemetry-collectors-language-sdks#apm-instrument-apps-otel) or [OpenTelemetry collector](/docs/solutions/observability/apm/opentelemetry/upstream-opentelemetry-collectors-language-sdks#apm-connect-open-telemetry-collector).
</tip>