﻿---
title: Metadata
description: Metadata can enrich your events and make application performance monitoring even more useful. Let’s explore the different types of metadata that Elastic...
url: https://www.elastic.co/docs/solutions/observability/apm/metadata
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Metadata
Metadata can enrich your events and make application performance monitoring even more useful. Let’s explore the different types of metadata that Elastic APM offers.

## Labels

Labels add **indexed** information to transactions, spans, and errors. Indexed means the data is searchable and aggregatable in Elasticsearch. Add additional key-value pairs to define multiple labels.
- Indexed: Yes
- Elasticsearch type: [object](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/object)
- Elasticsearch field: `labels`
- Applies to: [Transactions](https://www.elastic.co/docs/solutions/observability/apm/transactions)  [Spans](https://www.elastic.co/docs/solutions/observability/apm/spans)  [Errors](https://www.elastic.co/docs/solutions/observability/apm/errors)

Label values can be a string, boolean, or number, although some agents only support string values at this time. Because labels for a given key, regardless of agent used, are stored in the same place in Elasticsearch, all label values of a given key must have the same data type. Multiple data types per key will throw an exception, for example: `{foo: bar}` and `{foo: 42}` is not allowed.
<important>
  Avoid defining too many user-specified labels. Defining too many unique fields in an index is a condition that can lead to a [mapping explosion](/docs/manage-data/data-store/mapping#mapping-limit-settings).
</important>


### Agent API reference

- Go: [`SetLabel`](https://www.elastic.co/docs/reference/apm/agents/go/api-documentation#context-set-label)
- Java: [`setLabel`](https://www.elastic.co/docs/reference/apm/agents/java/public-api#api-transaction-add-tag)
- .NET: [`SetLabel`](https://www.elastic.co/docs/reference/apm/agents/dotnet/public-api#api-transaction-set-label)
- Node.js: [`setLabel`](https://www.elastic.co/docs/reference/apm/agents/nodejs/agent-api#apm-add-labels)
- PHP: [`Transaction` `setLabel`](https://www.elastic.co/docs/reference/apm/agents/php/public-api#api-transaction-interface-set-label)  [`Span` `setLabel`](https://www.elastic.co/docs/reference/apm/agents/php/public-api#api-span-interface-set-label)
- Python: [`elasticapm.label()`](https://www.elastic.co/docs/reference/apm/agents/python/api-reference#api-label)
- Ruby:  [`set_label`](https://www.elastic.co/docs/reference/apm/agents/ruby/api-reference#api-agent-set-label)
- Rum: [`addLabels`](https://www.elastic.co/docs/reference/apm/agents/rum-js/agent-api#apm-add-labels)


## Custom context

Custom context adds **non-indexed**, custom contextual information to transactions and errors. Non-indexed means the data is not searchable or aggregatable in Elasticsearch, and you cannot build dashboards on top of the data. This also means you don’t have to worry about [mapping explosions](/docs/manage-data/data-store/mapping#mapping-limit-settings), as these fields are not added to the mapping.
Non-indexed information is useful for providing contextual information to help you quickly debug performance issues or errors.
- Indexed: No
- Elasticsearch type: [object](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/object)
- Elasticsearch fields: `transaction.custom`  `error.custom`
- Applies to: [Transactions](https://www.elastic.co/docs/solutions/observability/apm/transactions)  [Errors](https://www.elastic.co/docs/solutions/observability/apm/errors)

<important>
  Setting a circular object, a large object, or a non JSON serializable object can lead to errors.
</important>


### Agent API reference

- Go: [`SetCustom`](https://www.elastic.co/docs/reference/apm/agents/go/api-documentation#context-set-custom)
- iOS: *coming soon*
- Java: [`addCustomContext`](https://www.elastic.co/docs/reference/apm/agents/java/public-api#api-transaction-add-custom-context)
- .NET: *coming soon*
- Node.js: [`setCustomContext`](https://www.elastic.co/docs/reference/apm/agents/nodejs/agent-api#apm-set-custom-context)
- PHP: *coming soon*
- Python: [`set_custom_context`](https://www.elastic.co/docs/reference/apm/agents/python/api-reference#api-set-custom-context)
- Ruby: [`set_custom_context`](https://www.elastic.co/docs/reference/apm/agents/ruby/api-reference#api-agent-set-custom-context)
- Rum: [`setCustomContext`](https://www.elastic.co/docs/reference/apm/agents/rum-js/agent-api#apm-set-custom-context)


## User context

User context adds **indexed** user information to transactions and errors. Indexed means the data is searchable and aggregatable in Elasticsearch.
- Indexed: Yes
- Elasticsearch type: [keyword](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/keyword)
- Elasticsearch fields: `user.email`  `user.name`  `user.id`
- Applies to: [Transactions](https://www.elastic.co/docs/solutions/observability/apm/transactions)  [Errors](https://www.elastic.co/docs/solutions/observability/apm/errors)


### Agent API reference

- Go: [`SetUsername`](https://www.elastic.co/docs/reference/apm/agents/go/api-documentation#context-set-user-email)
- iOS: *coming soon*
- Java: [`setUser`](https://www.elastic.co/docs/reference/apm/agents/java/public-api#api-transaction-set-user)
- .NET *coming soon*
- Node.js: [`setUserContext`](https://www.elastic.co/docs/reference/apm/agents/nodejs/agent-api#apm-set-user-context)
- PHP: *coming soon*
- Python: [`set_user_context`](https://www.elastic.co/docs/reference/apm/agents/python/api-reference#api-set-user-context)
- Ruby: [`set_user`](https://www.elastic.co/docs/reference/apm/agents/ruby/api-reference#api-agent-set-user)
- Rum: [`setUserContext`](https://www.elastic.co/docs/reference/apm/agents/rum-js/agent-api#apm-set-user-context)