﻿---
title: Manage storage
description: Elastic Agent uses data streams to store time series data across multiple indices. Index templates are used to configure the backing indices of data streams...
url: https://www.elastic.co/docs/solutions/observability/apm/manage-storage
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Manage storage
Elastic Agent uses [data streams](https://www.elastic.co/docs/solutions/observability/apm/data-streams) to store time series data across multiple indices. [Index templates](https://www.elastic.co/docs/solutions/observability/apm/view-elasticsearch-index-template) are used to configure the backing indices of data streams as they are created. Each data stream ships with a customizable [index lifecycle policy](https://www.elastic.co/docs/solutions/observability/apm/index-lifecycle-management) that automates data retention as your indices grow and age. Use [ingest pipelines](https://www.elastic.co/docs/solutions/observability/apm/parse-data-using-ingest-pipelines) to process and enrich APM documents before indexing them.
The [storage and sizing guide](https://www.elastic.co/docs/solutions/observability/apm/storage-sizing-guide) attempts to define a "typical" storage reference for Elastic APM, and there are additional settings you can tweak to [reduce storage](https://www.elastic.co/docs/solutions/observability/apm/reduce-storage), or to [tune data ingestion in Elasticsearch](/docs/solutions/observability/apm/apm-server/tune-data-ingestion#apm-tune-elasticsearch).
In addition, the Applications UI makes it easy to visualize your APM data usage with [storage explorer](https://www.elastic.co/docs/solutions/observability/apm/storage-explorer). Storage explorer allows you to analyze the storage footprint of each of your services to see which are producing large amounts of data—so you can better reduce the data you’re collecting or forecast and prepare for future storage needs.