﻿---
title: Logs
description: The Logs tab shows contextual logs for the selected service. Logs provide detailed information about specific events, and are crucial to successfully...
url: https://www.elastic.co/docs/solutions/observability/apm/logs
products:
  - APM
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Logs
The **Logs** tab shows contextual logs for the selected service.
Logs provide detailed information about specific events, and are crucial to successfully debugging slow or erroneous transactions.
If you’ve correlated your application’s logs and traces, you never have to search for relevant data; it’s already available to you. Viewing log and trace data together allows you to quickly diagnose and solve problems.
To learn how to correlate your logs with your instrumented services, refer to [Stream application logs](https://www.elastic.co/docs/solutions/observability/logs/stream-application-logs).
![Example view of the Logs tab in Applications UI](https://www.elastic.co/docs/solutions/images/observability-logs.png)

<tip>
  Logs displayed on this page are filtered on `service.name`
</tip>


### View enhanced logs

<applies-to>
  - Elastic Stack: Preview since 9.0
</applies-to>

For an enhanced logs view with additional information including the log pattern, the number of events for each log, change type, and the time the change occurred, turn on the `observability:newLogsOverview` [advanced setting](https://www.elastic.co/docs/reference/kibana/advanced-settings#kibana-search-settings).

## Integrate with logging frameworks

<applies-to>
  - Elastic Stack: Generally available
</applies-to>

Elastic APM integrates with popular logging frameworks, making it easy to correlate your logs and traces. This enables you to:
- View the context of a log and the parameters provided by a user
- View all logs belonging to a particular trace
- Easily move between logs and traces when debugging application issues

See the [Stream application logs](https://www.elastic.co/docs/solutions/observability/logs/stream-application-logs) guide to get started.