﻿---
title: Interpret application data
description: Learn how to get the most out of your data using the Applications UI. 
url: https://www.elastic.co/docs/solutions/observability/apm/interpret-data
products:
  - APM
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Interpret application data
Learn how to get the most out of your data using the Applications UI.

|                                                                                                                                                               |                                                                                                                                                                                                                                              |
|---------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Finding transaction latency and failure correlations](https://www.elastic.co/docs/solutions/observability/apm/find-transaction-latency-failure-correlations) | Surface characteristics of your data that are potentially correlated with high-latency or erroneous transactions.                                                                                                                            |
| [Tracking deployments with annotations](https://www.elastic.co/docs/solutions/observability/apm/track-deployments-with-annotations)                           | Annotations enable you to easily determine if your deployment has increased response times for an end-user or if the memory/CPU footprint of your application has changed.                                                                   |
| [Exploring mobile sessions with Discover](https://www.elastic.co/docs/solutions/observability/apm/explore-mobile-sessions)                                    | **Elastic Stack only:** Use session tracking via a globally unique identifier to explore the activities of a specific user during a specific period of time.                                                                                 |
| [Observing Lambda functions](https://www.elastic.co/docs/solutions/observability/apm/observe-lambda-functions)                                                | Learn how your AWS Lambda functions relate to and depend on other services, and get insight into function execution and runtime behavior, like lambda duration, cold start rate, cold start duration, compute usage, memory usage, and more. |