﻿---
title: Monitoring AWS Lambda Functions
description: Elastic APM lets you monitor your AWS Lambda functions. The natural integration of distributed tracing into your AWS Lambda functions provides insights...
url: https://www.elastic.co/docs/solutions/observability/apm/ingest/monitor-aws-lambda-functions
products:
  - APM
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Monitoring AWS Lambda Functions
Elastic APM lets you monitor your AWS Lambda functions. The natural integration of [distributed tracing](/docs/solutions/observability/apm/traces#apm-distributed-tracing) into your AWS Lambda functions provides insights into the function’s execution and runtime behavior as well as its relationships and dependencies to other services.

## AWS Lambda architecture

AWS Lambda uses a special execution model to provide a scalable, on-demand compute service for code execution. In particular, AWS freezes the execution environment of a lambda function when no active requests are being processed. This execution model poses additional requirements on APM in the context of AWS Lambda functions:
1. To avoid data loss, APM data collected by APM agents needs to be flushed before the execution environment of a lambda function is frozen.
2. Flushing APM data must be fast so as not to impact the response times of lambda function requests.

To accomplish the above, Elastic APM agents instrument AWS Lambda functions and dispatch APM data via an [AWS Lambda extension](https://docs.aws.amazon.com/lambda/latest/dg/using-extensions.html).
Normally, during the execution of a Lambda function, there’s only a single language process running in the AWS Lambda execution environment. With an AWS Lambda extension, Lambda users run a *second* process alongside their main service/application process.
![image showing data flow from lambda function](https://www.elastic.co/docs/solutions/images/serverless-apm-agents-aws-lambda-functions-architecture.png)

By using an AWS Lambda extension, Elastic APM agents can send data to a local Lambda extension process, and that process will forward data on to the managed intake service asynchronously. The Lambda extension ensures that any potential latency between the Lambda function and the managed intake service instance will not cause latency in the request flow of the Lambda function itself.

## Setup

To get started with the setup of Elastic APM for your Lambda functions, checkout the language-specific guides:
- [Quick Start with APM on AWS Lambda - Node.js](https://www.elastic.co/docs/reference/apm/agents/nodejs/lambda)
- [Quick Start with APM on AWS Lambda - Python](https://www.elastic.co/docs/reference/apm/agents/python/lambda-support)
- [Quick Start with APM on AWS Lambda - Java](https://www.elastic.co/docs/reference/apm/agents/java/aws-lambda)

Or, see the [architecture guide](https://www.elastic.co/docs/reference/apm/aws-lambda) to learn more about how the extension works, performance impacts, and more.