﻿---
title: Collect application data
description: Use Elastic APM agents or an OpenTelemetry language SDK to instrument a service in the language its written in: OpenTelemetry: OpenTelemetry is an open...
url: https://www.elastic.co/docs/solutions/observability/apm/ingest
products:
  - APM
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Collect application data
<note>
  **For Observability Serverless projects**, the **Admin** role or higher is required to send APM data to Elastic. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles).
</note>


## Language-specific options

Use Elastic APM agents or an OpenTelemetry language SDK to instrument a service in the language its written in:
- [**OpenTelemetry**](https://www.elastic.co/docs/solutions/observability/apm/opentelemetry): OpenTelemetry is an open source set of APIs, SDKs, tooling, and integrations that enable the capture and management of telemetry data from your services and applications. Elastic offers [Elastic Distributions of OpenTelemetry (EDOT)](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks), which are customized versions of [OpenTelemetry language SDKs](https://opentelemetry.io/docs/languages/) that are optimized to work with an Elastic backend.
- [**Elastic APM agents**](https://www.elastic.co/docs/solutions/observability/apm/apm-agents): Elastic APM agents are instrumentation libraries written in the same language as your service.

**Not sure which method is right for you?** Compare the available options.

### Capabilities


|                           | Elastic Distributions of OpenTelemetry (EDOT)                                                                                                               | Elastic APM agent                                                                                                                                           |
|---------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Support level**         | Fully supported for available languages                                                                                                                     | Fully supported                                                                                                                                             |
| **Data protocol**         | [OpenTelemetry protocol (OTLP)](https://opentelemetry.io/docs/specs/otel/protocol/)                                                                         | Elastic protocol                                                                                                                                            |
| **Central configuration** | <applies-to>: Preview</applies-to> Supported*Refer to* [*Central configuration*](https://www.elastic.co/docs/reference/opentelemetry/central-configuration) | Supported*Refer to* [*APM agent central configuration*](https://www.elastic.co/docs/solutions/observability/apm/apm-server/apm-agent-central-configuration) |

For a comparison of EDOT and APM data streams, refer to [Comparison with classic APM data streams](https://www.elastic.co/docs/reference/opentelemetry/compatibility/data-streams#comparison-with-classic-apm-data-streams).

### Availability


| Language    | Elastic Distributions of OpenTelemetry (EDOT) | Elastic APM agent |
|-------------|-----------------------------------------------|-------------------|
| **Android** | EDOT Android                                  | Not available     |
| **Go**      | Not available                                 | Go agent          |
| **iOS**     | EDOT iOS                                      | Not available     |
| **Java**    | EDOT Java                                     | Java agent        |
| **.NET**    | EDOT .NET                                     | .NET agent        |
| **Node.js** | EDOT Node.js                                  | Node.js agent     |
| **PHP**     | EDOT PHP                                      | PHP agent         |
| **Python**  | EDOT Python                                   | Python agent      |
| **Ruby**    | Not available                                 | Ruby agent        |


## Service-specific options

Elastic also offers several tools to help you collect data from specific services:
- **Kubernetes**: The Elastic APM attacher for Kubernetes simplifies the instrumentation and configuration of your application pods. Read more in the [APM attacher for Kubernetes docs](https://www.elastic.co/docs/reference/apm/k8s-attacher).
- **AWS Lambda Functions**: Helps you monitor your AWS Lambda functions. Read more in the [APM Architecture for AWS Lambda docs](https://www.elastic.co/docs/reference/apm/aws-lambda).
- **Jaeger (deprecated)**: Helps you to switch an existing Jaeger setup from the default Jaeger backend to the Elastic Stack. Read more in [Integrate with Jaeger](https://www.elastic.co/docs/solutions/observability/apm/ingest/jaeger).