﻿---
title: Infrastructure
description: The Infrastructure tab provides information about the containers, pods, and hosts that the selected service is linked to. Pods: Uses the kubernetes.pod.name...
url: https://www.elastic.co/docs/solutions/observability/apm/infrastructure
products:
  - APM
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Infrastructure
<important>
  The Applications UI Infrastructure functionality is in beta and is subject to change. The design and code is less mature than official generally available features and is being provided as-is with no warranties.
</important>

The **Infrastructure** tab provides information about the containers, pods, and hosts that the selected service is linked to.
- **Pods**: Uses the `kubernetes.pod.name` from the [APM metrics data streams](https://www.elastic.co/docs/solutions/observability/apm/metrics).
- **Containers**: Uses the `container.id` from the [APM metrics data streams](https://www.elastic.co/docs/solutions/observability/apm/metrics).
- **Hosts**: If the application is containerized—if the APM metrics documents include `container.id`—the `host.name` is used from the infrastructure data streams (filtered by `container.id`). If not, `host.hostname` is used from the APM metrics data streams.

![Example view of the Infrastructure tab in the Applications UI](https://www.elastic.co/docs/solutions/images/serverless-infra.png)

IT ops and software reliability engineers (SREs) can use this tab to quickly find a service’s underlying infrastructure resources when debugging a problem. Knowing what infrastructure is related to a service allows you to remediate issues by restarting, killing hanging instances, changing configuration, rolling back deployments, scaling up, scaling out, and so on.
<tip>
  **Why is the infrastructure tab empty?**If there is no data in the Application UI’s infrastructure tab for a selected service, you can read more about why this happens and how to fix it in the [troubleshooting docs](/docs/troubleshoot/observability/apm/common-problems#troubleshooting-apm-infra-data).
</tip>