﻿---
title: Get started with traces and APM
description: Elastic APM receives performance data from your APM agents or Elastic Distributions of OpenTelemetry (EDOT) SDKs, validates and processes it, and then...
url: https://www.elastic.co/docs/solutions/observability/apm/get-started
products:
  - APM
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Get started with traces and APM
Elastic APM receives performance data from your APM agents or [Elastic Distributions of OpenTelemetry (EDOT) SDKs](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks), validates and processes it, and then transforms the data into Elasticsearch documents.
In this guide you'll learn how to collect and send Application Performance Monitoring (APM) data to Elastic, then explore and visualize the data in real time.
<note>
  For a general Elastic Observability overview, refer to [Get started with observability](https://www.elastic.co/docs/solutions/observability/get-started).
</note>


## Send data to Elastic APM

Follow these steps to send APM data to Elastic.
<admonition title="Required role">
  **For Observability Serverless projects**, the **Admin** role or higher is required to send APM data to Elastic. To learn more, refer to [Assign user roles and privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles).
</admonition>

<stepper>
  <step title="Create an Observability project">
    An Elastic Observability Serverless project allows you to run Elastic Observability Serverless in an autoscaled and fully-managed environment, where you don’t have to manage the underlying Elasticsearch cluster or Kibana instances.
    <dropdown title="Steps for creating a project">
      <note>
        The **Admin** role or higher is required to create projects. Refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/manage-users#general-assign-user-roles).
      </note>

      1. Navigate to [cloud.elastic.co](https://cloud.elastic.co/) and log in to your account, or create one.
      2. Select **Create serverless project**.
      3. Under **Elastic for Observability**, select **Next**.
      4. Enter a name for your project and select **Observability Complete**.
      5. (Optional) Select **Edit settings** to change your project settings:
         - **Cloud provider**: The cloud platform where you’ll deploy your project. We currently support Amazon Web Services (AWS).
      - **Region**: The [region](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/regions) where your project will live.
      6. Select **Create project**. It takes a few minutes to create your project.
      7. When the project is ready, click **Continue**.
    </dropdown>
  </step>

  <step title="Add data using EDOT or APM Agents">
    To send APM data to Elastic, you must install an Elastic Distribution of OpenTelemetry or an APM agent and configure it to send data to your project:
    1. Bring traces, logs, and metrics into Elastic APM to help you troubleshoot and optimize your applications. You can collect this data using OpenTelemetry or APM Server.
       <dropdown title="Steps for collecting application traces, metrics, and logs">
       <tab-set>
       <tab-item title="OpenTelemetry">
       The [Elastic Distribution of OpenTelemetry Collector SDKs](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks) facilitate the collection of traces, metrics, and logs in OpenTelemetry format into Elastic APM.
       1. Select **Add data** from the main menu and then select **Application**.
       2. Select **OpenTelemetry**.
       3. Follow the instructions for your platform.
       </tab-item>

       <tab-item title="APM agents">
       Use the [APM agents](https://www.elastic.co/docs/solutions/observability/apm/apm-agents) to collect traces, metrics, and logs through APM Server or the managed intake service.
       1. Select **Add data** from the main menu and then select **Application**.
       2. Select **Elastic APM**.
       3. Select the tab for your language or framework.
       4. Follow the instructions in the tab.
       </tab-item>
       </tab-set>
       </dropdown>
    2. If you’re using the step-by-step instructions in the UI, after you’ve installed and configured an agent, you can click **Check Agent Status** to verify that the agent is sending data.
    To learn more about APM agents, including how to fine-tune how agents send traces to Elastic, refer to [Collect application data](https://www.elastic.co/docs/solutions/observability/apm/ingest).
  </step>

  <step title="View your data">
    After one or more APM agents are installed and successfully sending data, you can view application performance monitoring data in the UI.In the **Applications** section of the main menu, select **Service Inventory**. This will show a high-level overview of the health and general performance of all your services.Learn more about visualizing APM data in [View and analyze data](https://www.elastic.co/docs/solutions/observability/apm/view-analyze-data).
    <tip>
      Not seeing any data? Find helpful tips in [Troubleshooting](https://www.elastic.co/docs/troubleshoot/observability/apm).
    </tip>
  </step>
</stepper>


## Next steps

Now that data is streaming into your project, take your investigation to a deeper level. Learn how to use [Elastic’s built-in visualizations for APM data](https://www.elastic.co/docs/solutions/observability/apm/view-analyze-data), [alert on APM data](https://www.elastic.co/docs/solutions/observability/incident-management/alerting), or [fine-tune how agents send traces to Elastic](https://www.elastic.co/docs/solutions/observability/apm/ingest).