﻿---
title: Filter application data
description: Global filters are ways you can filter your APM data based on a specific time range or environment. When viewing a specific service, the filter persists...
url: https://www.elastic.co/docs/solutions/observability/apm/filter-data
products:
  - APM
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Filter application data
Global filters are ways you can filter your APM data based on a specific time range or environment. When viewing a specific service, the filter persists as you move between tabs.
![Global filters view](https://www.elastic.co/docs/solutions/images/observability-global-filters.png)

<note>
  If you prefer to use advanced queries on your data to filter on specific pieces of information, see [Query your data](https://www.elastic.co/docs/solutions/observability/apm/advanced-queries).
</note>


## Global time range

The global time range filter restricts APM data to a specific time period.

## Service environment filter

The environment selector is a global filter for `service.environment`. It allows you to view only relevant data and is especially useful for separating development from production environments. By default, all environments are displayed. If there are no environment options, you’ll see "not defined".
Service environments are defined when configuring your APM agents. It’s vital to be consistent when naming environments in your APM agents. To learn how to configure service environments, see the specific APM agent documentation:
- **Go:** [`ELASTIC_APM_ENVIRONMENT`](https://www.elastic.co/docs/reference/apm/agents/go/configuration#config-environment)
- **iOS agent:** *Not yet supported*
- **Java:** [`environment`](https://www.elastic.co/docs/reference/apm/agents/java/config-core#config-environment)
- **.NET:** [`Environment`](https://www.elastic.co/docs/reference/apm/agents/dotnet/config-core#config-environment)
- **Node.js:** [`environment`](https://www.elastic.co/docs/reference/apm/agents/nodejs/configuration#environment)
- **PHP:** [`environment`](https://www.elastic.co/docs/reference/apm/agents/php/configuration-reference#config-environment)
- **Python:** [`environment`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-environment)
- **Ruby:** [`environment`](https://www.elastic.co/docs/reference/apm/agents/ruby/configuration#config-environment)
- **Real User Monitoring (Elastic Stack only):** [`environment`](https://www.elastic.co/docs/reference/apm/agents/rum-js/configuration#environment)